#pragma rtGlobals=1		// Use modern global access method.
#pragma version=2.25

Strconstant MDVersion="2.2.5.0"

// ************************************************************************************************************************************
// ** MultiDepol Macro
// **
// ** v 1.1 changes by Jakob:
// ** 	- Linear leak correction now works for sinewaves that have a different number of points per wave than 20
// ** 	- Added option to use the p/n waves recorded by Pulse for leak correction (for waves that have been exported
// ** 		without p/n leak correction)
// ** 	- The current waves used for calculation of Qreal can optionally be kept after the end of analysis (together
// ** 		with XChart and p/n data)
// ** 	- The Rs for each recording is saved in the Rs wave
// **		- If you measured temperature, this is saved in the Tp wave 
// ** 	- The dialog for choosing Pulse / XChart files now only displays *.dat / *.tree files by default
// ** 	- Lots of minor 'cosmetical' changes (added 2nd Cm graph, colours of some traces, typos, ...)
// ** 	- Added lots of comments to the source
// **		- Bug in get_filenames() fixed (testfilename string was not set properly under some circumstances)
// ** v 1.2 change by Jakob:
// **		- Added autocorrection of names for exported waves (.ibw instead of .bwav when exporting from Windows)
// ** v 1.2.1 change by Jakob
// **		- Fixed bug which did not allow lowerspaces in the first 3 characters of the exported wave filename (Analyze() function, xcsweepno = ...)
// ** v 1.9.1 change by Jakob:
// **		- started preparations for v 2.0
// ** v 1.9.9 changes by Jakob
// **		- New dialog allows selection of sweeps to analyze, thus removing neccessity to export from Pulse / PM.
// **		- PM is fully supported now (hopefully, needs some real life testing).
// **		- New leak correction method "separate p/N pulse series": tries to build a leak wave from the previously recorded
// **			series, if this has a depolarization that's of the correct length. If the depol goes to the same level as the trace to be analyzed,
// **			it will correct by the previous trace's p/n leak pulse, if not it will assume that this trace is a scaled-down version and scales it up.
// **			This still needs to be improved so that one can actually do several repetitions of the leak...
// **		- Default value for time to skip after depol is now 100 ms!
// **		- Default value for liquid junction potential is now -14 mV!
// **		- Display: graphs are scaled automatically to span entire screen width.
// **		- Added option to do a zero subtraction on the current (recommended to leave ON!).
// **		- Added option to automatically bin your results by depol duration after analysis.
// ** 	- Added experimental option to do a slope correction. NOT RECOMMENDED!
// ** 	- Added "Currents only mode" which allows you to analyze only currents (skipping the Cm data) and will allow you
// ** 		to also select series which do not contain any Cm data on the list.
// **		- Exclusion criteria actually work now.
// ** 	- The macro runs much faster now...
// ** v 2.0 changes by Jakob:
// **		- Added warning when suffix is too long.
// **		- Added /O to all duplicate commands.
// **		- Corrected wave declarations
// ** v 2.1 changes by Jakob:
// **		- Added Gm and Gs traces to selector display
// **		- Removed unused variable assignments
// ** v 2.2 changes by Aaron:
// ** 	- Adapting for importing patchmaster files (with Patcher's Power Tools v2.19, should in principle work with other versions)
// ** v 2.2.1 change by Jakob
// **		- adapted Qreal measurements for short (<3ms) depolarizations
// ** v 2.2.2 changes by Jakob
// **		- Added option to restrict x-range of traces in selector
// **		- Fixed leak correction 'separate p/N pulse series', should work now with preceeding or following leak pulse
// **			(code still needs clearing up, though...)
// ** v 2.2.3 changes by Jakob
// **		- Changed renaming of (Patchmaster) data
// **		- Missing _gm or _gs traces no longer cause error messages when selecting the recordings
// ** v 2.2.4 change by Jakob
// **		- Changed detection of 0 ms depols in md2_getNaNtimes() for Patchmaster, might be non-functional now?
// ************************************************************************************************************************************

 Function md2()

	md2_dialog_folders()
	md2_dialog_variables()
	md2_user_dialog()
	setdatafolder root:
	
End

// *****************************************************************************************************************************
// create the data folders used for storing the data of the user panel

Function md2_dialog_folders()

	if (! DataFolderExists ("root:MD2dialog"))
		NewDataFolder /O root:MD2dialog
	endif

	
	pathinfo md2XCpath
	if (! V_flag)
		newpath /q/z md2XCpath, "D:"
		if (V_flag != 0)
			newpath /q/z md2XCpath, "G:"
			if (V_flag != 0)
				newpath /o/q/z md2XCpath, "F:"
				if (V_flag != 0)
					newpath /o/q/z md2XCpath, "C:"
				endif
			endif
		endif
	endif
End

// ************************************************************************************************************************************
// ** Create the data folders for analysis: MD2temp (for temporary storage of the analyzed waves), CurrAnaFolder (named after the suffix,
// **   contains PoN (p over n) and Currents folders).

Function md2_Analysis_Folders()

	SVAR suffix=root:MD2dialog:suffix
	

	dowindow /k depol_graph					
	dowindow /k iwin_f
	dowindow /k iwin_d
	dowindow /k Qwin_f
	dowindow /k Qwin_d


	if (DataFolderExists("root:MD2temp"))
		KillDataFolder root:MD2temp
	endif
	newdatafolder /o/s root:MD2temp

	string/g CurrAnaFolder = "root:"+suffix
	
	if (DataFolderExists(CurrAnaFolder)==1)
		DoAlert 1, "\r\t A DataFolder named " + suffix + " already exists!\r\r\t Override this Folder and continue?"
		if (V_flag == 2)
			killdatafolder root:MD2temp
			abort
		endif
		killdatafolder $CurrAnaFolder
	endif
	newdatafolder /o/s $CurrAnaFolder

	newdatafolder /O PoN
	newdatafolder /O Currents				// Folder for storing the ICa traces used for calculating qreal
	
End

// ************************************************************************************************************************************
// ** Set up variables for the user dialog prior to use

Function md2_Dialog_Variables()

	SetDataFolder root:MD2dialog
	if (countobjects(":",2)==0)
		
		string /g DatFile
		string /g info="exp/date/name", suffix="suffix"
		string /g MD2WaveList				// This list will contain the waves selected for analysis
		
		variable /g screen=md2_getscreeninfo()	// Info about screen resolution; returns width of screen in pixels
		variable /g leaktype=2					// type of leak correction; 1 is linear leak correction, 2 is p/n
		variable /g Vlj=-14						// Liquid junction potential in mV
		variable /g Vrev=-45					// reversal potential in mV
		variable /g offsett=0					// Time of first recording (to be specified when no XChart file is available)
		variable /g Vhold=-70					// holding potential in mV (to be specified when no XChart file is available)
		variable /g XCgroup=1					// Pulse experiment group
		variable /g doleakcorr=0				// Whether the macro should do its own leak correction (1) or not (0)
		variable /g ExclCurr=-30				// Exclude traces where you have this current in pA ...
		variable /g skpt=100, avgtb=400, avgta=400, cnstb=2, cnsta=2	// skpt: time to skip after depol in ms, avgtb, avgta: time over which to average
											// capacitance before (b) and after (a) depol in ms, cnstb, cnsta: constant segment before and after depol in ms
		variable /g wtim_I=1.5, wtim_Cm=1.5, wtim_Q=1.5			// display time for current, capacitance and charge windows in s
		variable /g Patchmaster=NaN			// Is set to 1 when reading Patchmaster data or 0 when reading Pulse data.
		variable /G root:MD2dialog:MD2_RSeries	// For display of series resistance in selector window
		variable /G root:MD2dialog:MD2_Leak		// For display of leak current (mean of first ms) in selector window
		variable /G root:MD2dialog:MD2_RScomp	// For display of series resistance compensation in selector window
		variable /G root:MD2dialog:MD2_Cslow		// For display of Cslow in selector window
		variable /G root:MD2dialog:MD2_Gain		// For display of gain in selector window
		variable /G root:MD2dialog:MD2_VOffset		// For display of voltage offset in selector window
		variable /G root:MD2dialog:CurrentsOnly=0	// If set to 1, only analyze ICa and QCa, but also allow analysis of recordings without lockin parts
		variable /G root:MD2dialog:ZeroSubtract=1	// If set to 1, subtract zero current from the current trace
		variable /G root:MD2dialog:DoBin=1			// If set to 1, bin the overall results with depolarization duration as x-wave
		variable /G root:MD2dialog:DoSlopeCor=0	// If set to 1, correct the slope of the Cm trace by a linefit to the initial segment
		variable /G root:MD2dialog:TwoChan=0		// If set to 1, check if data in a second channel exists and do analysis for post-synaptic data
		variable /G root:MD2dialog:ShowFrom=0		// If set to 1, restrict the x-range of the traces to specified values:
		variable /G root:MD2dialog:ShowFromStart=0	// From here...
		variable /G root:MD2dialog:ShowFromEnd=4		// ...to here
		variable /G root:MD2dialog:SepPoNPulse=-1		// Leak correction is done with the pulse before (-1) or after (+1) the pulse to be corrected
	endif
End	


// ************************************************************************************************************************************	
// ** creates the user panel	

Function md2_user_dialog()

	SetDataFolder root:MD2dialog
	NVAR screen=root:MD2dialog:screen
	NVAR doleakcorr=root:MD2dialog:doleakcorr
	NVAR leaktype=root:MD2dialog:leaktype
	wave /Z/T ListWave=root:MD2dialog:ListWave
	SVAR MD2WaveList=root:MD2dialog:MD2WaveList
	
	DoWindow /K MD2UserDialog
	NewPanel /K=1 /W=(340,54,1040,449) as "MultiDepol Macro v"+MDversion
	DoWindow /C MD2UserDialog
	ModifyPanel cbRGB=(65435,65435,65435)
	SetDrawLayer UserBack
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawRect 1,0,703,396
	SetDrawEnv linefgc= (16384,16384,16384)
	SetDrawEnv save
	DrawLine 1,1,702,1
	DrawLine 1,-1,1,397
	DrawLine 1,59,702,59
	SetDrawEnv linefgc= (32768,32768,32768)
	SetDrawEnv save
	DrawLine -2,3,702,3
	DrawLine 0,-1,0,397
	DrawLine -2,58,702,58
	SetDrawEnv linethick= 2,linefgc= (54272,53248,51200)
	SetDrawEnv save
	DrawLine -2,2,702,2
	DrawLine -2,57,702,57
	SetDrawEnv linethick= 1,linefgc= (0,0,52224),fstyle= 6,textrgb= (0,0,52224)
	SetDrawEnv save
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 693,72,328,105
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 691,71,326,104
	DrawRect 690,70,325,103
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 334,70,507,70
	DrawText 338,77,"Information about Experiment"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 14,72,318,105
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 12,71,316,104
	DrawRect 11,70,315,103
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 20,70,100,70
	DrawText 24,77,"Wave's Suffix"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 14,115,318,149
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 12,114,316,148
	DrawRect 11,113,315,147
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 20,113,116,113
	DrawText 24,120,"Leak Correction"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 14,158,318,192
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 12,157,316,191
	DrawRect 11,156,315,190
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 20,156,131,156
	DrawText 24,163,"Reversal Potential"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 14,202,318,236
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 12,201,316,235
	DrawRect 11,200,315,234
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 20,200,164,200
	DrawText 24,207,"Liquid-Junction Potential"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 14,246,318,345
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 12,245,316,344
	DrawRect 11,244,315,343
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 20,244,120,244
	SetDrawEnv fname= "Symbol"
	DrawText 24,251,"D"
	DrawText 31,251,"Cm Calculation"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 328,115,693,236
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 326,114,691,235
	DrawRect 325,113,690,234
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 334,113,429,113
	DrawText 338,120,"Display Options"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 328,246,693,345
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 326,245,691,344
	DrawRect 325,244,690,343
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 334,244,426,244
	DrawText 338,251,"Further Options"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 14,355,318,388
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 12,354,316,387
	DrawRect 11,353,315,386
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 20,353,121,353
	DrawText 24,358,"Exclusion Criteria"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 328,355,490,388
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 326,354,488,387
	DrawRect 325,353,487,386
	SetDrawEnv linefgc= (65535,65535,65535)
	DrawLine 334,353,386,353
	DrawText 338,358,"Storage"
	SetDrawEnv fname= "MS Sans Serif",fstyle= 0,textrgb= (0,0,0)
	SetDrawEnv save
	SetDrawEnv textrgb= (30464,30464,30464)
	DrawText 18,181,"Enter the reversal potential (mV)"
	DrawText 18,225,"Enter the liquid junction potential (mV)"
	DrawText 18,272,"Time to skip after depolarisations (ms)"
	DrawText 18,292,"Maximum average time before depolarisations (ms)"
	DrawText 18,312,"Maximum average time after depolarisations (ms)"
	DrawText 18,332,"Constant segment Length (ms)"
	DrawText 237,332,"post"
	DrawText 174,332,"pre"
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 591,355,498,388
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 589,354,496,387
	SetDrawEnv linefgc= (12288,44032,11520),linebgc= (12288,44032,11520),fillfgc= (12288,44032,11520),fillbgc= (12288,44032,11520)
	DrawRect 588,353,495,386
	SetDrawEnv linefgc= (60928,60928,60928),fillfgc= (60928,60928,60928)
	DrawRect 693,355,600,388
	SetDrawEnv linefgc= (52224,52224,52224),fillfgc= (52224,52224,52224)
	DrawRect 691,354,598,387
	SetDrawEnv linefgc= (65280,0,0),linebgc= (65280,0,0),fillfgc= (65280,0,0),fillbgc= (65280,0,0)
	DrawRect 690,353,597,386
	DrawText 18,181,"Enter the reversal potential (mV)"
	SetDrawEnv textrgb= (30464,30464,30464)
	DrawText 18,181,"Enter the reversal potential (mV)"
	SetDrawEnv textrgb= (30464,30464,30464)
	DrawText 18,181,"Enter the reversal potential (mV)"
	SetDrawEnv textrgb= (30464,30464,30464)
	DrawText 18,181,"Enter the reversal potential (mV)"
	DrawText 18,181,"Enter the reversal potential (mV)"
	Button b_GetDatFile,pos={12,7},size={70,20},proc=md2_SelectFile,title="Pulse file"
	Button b_GetDatFile,help={"Location of the original Pulse data file."}
	SetVariable v_DatFileName,pos={87,8},size={608,16},title=" "
	SetVariable v_DatFileName,help={"Location of the original Pulse data file."}
	SetVariable v_DatFileName,value= root:MD2dialog:DatFile
	Button md2_reselect_series,pos={12,32},size={90,20},proc=md2_ReselectButtonProc,title="Reselect Series"
	Button md2_reselect_series,help={"Change the selection of series for analysis."}
	TitleBox md2_numofseries,pos={112,35},size={105,13},title="Series selected: "+num2str(itemsinlist(MD2WaveList))+" of "+num2str(dimsize(ListWave,0))
	TitleBox md2_numofseries,help={"How many series of the .dat file have been selected"}
	TitleBox md2_numofseries,frame=0
	Button md2_CleanUpButton,size={90,20}, pos={604,32}
	Button md2_CleanUpButton,title="Clean Up",proc=md2_CleanUpButtonProc,help={"Delete the MD2AllSeries folder containing the traces imported from the .dat file. Do this when you're done to save disk space."}
	SetVariable v_infowave,pos={333,79},size={348,16},title=" "
	SetVariable v_infowave,help={"Information about the experiment which will be saved in the infowave."}
	SetVariable v_infowave,labelBack=(61928,61928,61928),frame=0
	SetVariable v_infowave,value= root:MD2dialog:info
	SetVariable v_suffix,pos={19,79},size={287,16},title=" "
	SetVariable v_suffix,help={"The suffix used for labeling the analysis results"}
	SetVariable v_suffix,labelBack=(61928,61928,61928),frame=0
	SetVariable v_suffix,value= root:MD2dialog:suffix
	if  (doleakcorr == 1)
		if (leaktype == 1)
			CheckBox cMainLeak, pos={18,125},size={162,14}, value=1, variable=root:MD2dialog:doleakcorr, title="Leak correction is switched on: 'linear leak'", proc=md2_MnChckbxCntrl, help={"Linear leak correction by drawing a line through the avg leak at holding potential and the zero leak at reversal potential."}
			DrawText 18,181,"Enter the reversal potential (mV)"
			SetVariable vVrev,pos={260,166},size={46,16},title=" ", limits={-Inf,inf,1},value= root:MD2dialog:Vrev, help={"The leak reversal potential used for calculating the slope of the linear leak correction."}
		elseif (leaktype == 2)
			CheckBox cMainLeak, pos={18,125},size={162,14}, value=1, variable=root:MD2dialog:doleakcorr, title="Leak correction is switched on: 'separate p/N pulses'", proc=md2_MnChckbxCntrl, help={"Looks for separate p/N leak correction series recorded after the pulse."}
			SetDrawEnv textrgb=(30464,30464,30464)
			DrawText 18,181,"Enter the reversal potential (mV)"
			SetVariable vVrev,pos={260,166},size={46,16},title=" ", limits={-Inf,inf,1},value= root:MD2dialog:Vrev, disable=0
			SetVariable vVrev,value= root:MD2dialog:SepPoNPulse
		endif
	else
		CheckBox cMainLeak, pos={18,125},size={162,14}, value=0, variable=root:MD2dialog:doleakcorr, title="Leak correction is switched off", proc=md2_MnChckbxCntrl, help={"Do not use leak correction or use traces which have previously been leak.corrected by Pulse."}
		SetDrawEnv textrgb=(30464,30464,30464)
		DrawText 18,181,"Enter the reversal potential (mV)"
		SetVariable vVrev,pos={260,166},size={46,16},title=" ", limits={-Inf,inf,1},value= root:MD2dialog:Vrev, disable=1, help={"Enter the reversal potential of the leak currents"}
		SetVariable vVrev,value= root:MD2dialog:Vrev
	endif
	SetVariable vVrev,pos={260,166},size={46,16},title=" "
//	SetVariable vVrev,value= root:MD2dialog:Vrev
	SetVariable vVlj,pos={260,210},size={46,16},title=" "
	SetVariable vVlj,help={"Potentials will be corrected for liquid junction potential by the entered value."}
	SetVariable vVlj,limits={-inf,0,1},value= root:MD2dialog:Vlj
	SetVariable vskpt,pos={260,258},size={46,16},title=" "
	SetVariable vskpt,help={"Time to skip for calculation of delta Cm after the end of depolarisation in ms."}
	SetVariable vskpt,limits={0,inf,10},value= root:MD2dialog:skpt
	SetVariable vavgtb,pos={260,278},size={46,16},title=" "
	SetVariable vavgtb,help={"Maximum length of Cm trace to average before depolarisation in ms."}
	SetVariable vavgtb,limits={0,inf,10},value= root:MD2dialog:avgtb
	SetVariable vavgta,pos={260,298},size={46,16},title=" "
	SetVariable vavgta,help={"Maximum length of Cm trace to average after depolarisation in ms."}
	SetVariable vavgta,limits={0,inf,10},value= root:MD2dialog:avgta
	SetVariable vcnstb,pos={192,318},size={41,16},title=" "
	SetVariable vcnstb,help={"Length of non-sinewave segment at holding potential before depol."}
	SetVariable vcnstb,limits={0,inf,1},value= root:MD2dialog:cnstb
	SetVariable vcnsta,pos={260,318},size={46,16},title=" "
	SetVariable vcnsta,help={"Length of non-sinewave segment at holding potential after depol."}
	SetVariable vcnsta,limits={0,inf,1},value= root:MD2dialog:cnsta
	CheckBox cMainDisp,pos={332,126},size={174,14},proc=md2_MnChckbxCntrl,title="Display of analysis is switched on"
	CheckBox cMainDisp,help={"Display graphs for delta Cm, current and charge analysis."}
	CheckBox cMainDisp,value= 1
	CheckBox cdisp_Cm,pos={350,148},size={272,14},proc=md2_swtchCntrl,title="Display graphs showing analysis of capacitance for (s)"
	CheckBox cdisp_Cm,help={"Display graph for Cm analysis for how many seconds."}
	CheckBox cdisp_Cm,value= 1
	SetVariable vwtim_Cm,pos={636,147},size={45,16},title=" "
	SetVariable vwtim_Cm,help={"Display graph for Cm analysis for how many seconds."}
	SetVariable vwtim_Cm,limits={0,inf,0.5},value= root:MD2dialog:wtim_Cm
	CheckBox cdisp_I,pos={350,168},size={246,14},proc=md2_swtchCntrl,title="Display graphs showing analysis of current for (s)"
	CheckBox cdisp_I,help={"Display graph for ICa analysis for how many seconds."}
	CheckBox cdisp_I,value= 1
	SetVariable vwtim_I,pos={636,167},size={45,16},title=" "
	SetVariable vwtim_I,help={"Display graph for ICa analysis for how many seconds."}
	SetVariable vwtim_I,limits={0,inf,0.5},value= root:MD2dialog:wtim_I
	CheckBox cdisp_Q,pos={350,188},size={246,14},proc=md2_swtchCntrl,title="Display graphs showing analysis of charge for (s)"
	CheckBox cdisp_Q,help={"Display graph for QCa analysis for how many seconds."}
	CheckBox cdisp_Q,value= 1
	SetVariable vwtim_Q,pos={636,187},size={45,16},title=" "
	SetVariable vwtim_Q,help={"Display graph for QCa analysis for how many seconds."}
	SetVariable vwtim_Q,limits={0,inf,0.5},value= root:MD2dialog:wtim_Q
	SetVariable vVhold,pos={638,299},size={45,16},disable=1,title=" "
	SetVariable vVhold,help={"The holding potential used for the recordings."}
	SetVariable vVhold,limits={-999,999,1},value= root:MD2dialog:Vhold
	SetVariable vtoffset,pos={638,319},size={47,16},disable=1,title=" "
	SetVariable vtoffset,help={"The start time of the first sweep in s."}
	SetVariable vtoffset,limits={-inf,inf,0},value= root:MD2dialog:offsett
	CheckBox cExclCrit,pos={18,365},size={134,14},proc=md2_MnChckbxCntrl,title="No data will be excluded"
	CheckBox cExclCrit,help={"Choose whether to exclude data where the leak current at a certain potential exceeds a certain value."}
	CheckBox cExclCrit,value= 0
	SetVariable vExclCurr,pos={129,364},size={38,16},disable=1,title=" "
	SetVariable vExclCurr,limits={-inf,0,1},value= root:MD2dialog:ExclCurr
	CheckBox cStrg,pos={332,365},size={145,14},proc=md2_MnChckbxCntrl,title="Discard traces after analysis"
	CheckBox cStrg,help={"Choose whether p/N leak pulses and current traces are deleted after analysis."}
	CheckBox cStrg,value= 0
	Button bChooser,pos={497,355},size={90,30},proc=md2_ButtonCntrl,title="C H O O S E R"
	Button bAnalyze,pos={599,355},size={90,30},proc=md2_ButtonCntrl,title="A N A L Y Z E"
	CheckBox md2_ZeroSubtract_ChkBox,pos={333,258},size={122,14},title="Subtract zero currents"
	CheckBox md2_ZeroSubtract_ChkBox,help={"Choose whether to subtract zero currents (leak currents at holding potential) from your current traces."}
	CheckBox md2_ZeroSubtract_ChkBox,variable= root:MD2dialog:ZeroSubtract
	CheckBox md2_Dobin_Chkbox title="Bin final results by depolarization duration"
	CheckBox md2_Dobin_Chkbox pos={333,278},variable=root:MD2dialog:DoBin
	CheckBox md2_Dobin_Chkbox help={"Choose if you want to bin your final results by depolarization duration (Average all data from the same depol length)"}
	CheckBox md2_TwoChan_Chkbox,pos={333,298},size={304,14},proc=MD2_TwoChanWarning,title="Under construction: Analyze postsynaptic recordings in second channel"
	CheckBox md2_TwoChan_Chkbox,variable= root:MD2dialog:TwoChan
	CheckBox md2_TwoChan_Chkbox help={"Under construction: Analyze postsynaptic recordings in second channel. Highly non-functional so far!"}
	CheckBox md2_SlopeCorr_Chkbox,pos={333,318},size={304,14},proc=MD2_SlopeCorrWarning,title="EXPERIMENTAL: Perform slope correction on the Cm traces"
	CheckBox md2_SlopeCorr_Chkbox,variable= root:MD2dialog:DoSlopeCor
	CheckBox md2_SlopeCorr_Chkbox help={"Experimental feature: Correct slope of Cm trave by fitting a line to the initial (pre-depol) segment. Highly non-functional!"}
End


// ************************************************************************************************************************************
// ** When Pulse file file button has been pressed

Function md2_SelectFile (cntrlname) : ButtonControl

	String cntrlname
	Variable	fRefNum
	String cmdstring
	String PulseOrPM

	SVAR DatFileName = root:MD2dialog:DatFile
	NVAR PatchMaster=root:MD2dialog:PatchMaster

	Open /R/T=".dat"/P=md2XCpath fRefNum

	if (strlen(S_filename)>0)
		if  (strsearch (LowerStr (S_fileName), ".dat", 0) > 0)
			DatFileName = S_FileName
			fstatus fRefNum
			newpath /o/q md2XCpath, S_Path
			freadline /N=4 fRefNum, PulseOrPM
			PatchMaster=stringmatch(PulseOrPM,"DAT2")
		endif

		Close fRefNum
		
		if (DataFolderExists("root:MD2allseries"))
			KillDataFolder root:MD2allseries
		endif
		newdatafolder /o/s root:MD2allseries

		If (Patchmaster)
			cmdstring="LoadPM/L/I/Q \""+DatFileName+"\";md2_RenamePM()"
			//cmdstring="LoadPM/L/I/Q \""+DatFileName+"\";md2_pm2pulse()"
		// TODO: Does the rename work with other recordings as well?
		else
			cmdstring="LoadPulse/L/I/Q/G \""+DatFileName+"\";md2_renppt()"
		endif
		NewPanel /K=1/N=md2_pleasewaitwin/W=(574,256,840,292) as "Please wait..."
		SetDrawLayer UserBack
		SetDrawEnv fsize= 14,fstyle= 1
		DrawText 38,24,"Loading data, please wait..."
		DoUpdate
		execute cmdstring
		Dowindow /K md2_pleasewaitwin
		md2_MakeList()
		md2_SelectorWin()
				
	endif	

End

// ************************************************************************************************************************************
// ** When CHOOSER or ANALYZE buttons have been pressed

Function md2_ButtonCntrl(cntrlname) : ButtonControl

	string cntrlname
	SVAR datfile=root:MD2dialog:datfile
	SVAR suffix=root:MD2dialog:suffix
	SVAR info=root:MD2dialog:info
	NVAR screen=root:MD2dialog:screen
	
	string ErrStr, execstr

	strswitch(cntrlname)
		case "bChooser":			// CHOOSER: toggle the chooser window open or close
			dowindow MDchooser
			if (V_flag)
				doWindow /K MDchooser
				killdatafolder root:mdchooser
			else
				execstr = "chooser()"
				execute execstr
			endif
		break
		case "bAnalyze":			// ANALYZE: Check for correct entry of all dialog fields and start analysis
			ControlInfo /W=md2UserDialog cXCa
			if((strlen(datfile)==0) || (stringmatch(suffix, "suffix")==1) || (strlen(suffix)>15))
					ErrStr = "\r"
				if(strlen(datfile)==0)
					ErrStr +="\tPlease select Pulse/Patchmaster .dat file.\r"
				endif
				if(stringmatch(suffix, "suffix")==1)
					ErrStr +="\tPlease enter suffix to attach to wavenames.\r"
				endif
				if(strlen(suffix)>15)
					ErrStr +="\tSuffix is too long - please use no more than 15 characters.\r\t(That would be "+num2str(strlen(suffix)-15)+" character(s) less)"
				endif
				doalert 0, ErrStr
			else
				if (!stringmatch(suffix,cleanupname(suffix,0)))
					ErrStr="\rInvalid suffix - changed to \""+cleanupname(suffix,0)+"\". Proceed?"
					doalert 1, ErrStr
					if (V_flag==2)
						break
					else
						suffix=cleanupname(suffix,0)
					endif
				endif
				screen=md2_getscreeninfo()
				md2_Analyze()
			endif
		break					
	endswitch
End

// ************************************************************************************************************************************

Function md2_MnChckbxCntrl(CntrlName,checked) : CheckBoxControl

	String CntrlName
	Variable checked
	
	strswitch (CntrlName)
		case "cMainLeak":
			NVAR leaktype = root:MD2dialog:leaktype
			if (checked == 0) // no leak correction or data is already leak corrected
				CheckBox cmainleak, title="Additional leak correction is switched off", help={"Do not use leak correction or use traces which have previously been leak.corrected by Pulse."}
				SetDrawEnv textrgb=(65535,65535,65535)
				DrawText 18,181,"Use preceeding (-1) or following (+1) pulse?"
				SetDrawEnv textrgb=(30464,30464,30464)
				DrawText 18,181,"Enter the reversal potential (mV)"
				SetVariable vVrev, disable=1
				break
			endif
			if ((checked == 1) && (leaktype == 2))
				leaktype=1 // linear leak correction
				CheckBox cmainleak, title="Leak correction is switched on: 'linear leak'", help={"Linear leak correction by drawing a line through the avg leak at holding potential and the zero leak at reversal potential."}
				DrawText 18,181,"Enter the reversal potential (mV)"
				SetVariable vVrev, disable=0
				SetVariable vVrev,value= root:MD2dialog:Vrev
				break
			endif
			if ((checked == 1) && (leaktype == 1))
				leaktype=2 // correction using separate p/N pulses
				CheckBox cmainleak, title="Leak correction is switched on: 'separate p/N pulse series'", help={"Looks for separate p/N leak correction series recorded after the pulse."}
				SetDrawEnv textrgb=(65535,65535,65535)
				DrawText 18,181,"Enter the reversal potential (mV)"
				SetDrawEnv textrgb=(0,0,0)
				DrawText 18,181,"Use preceeding (-1) or following (+1) pulse?"
				SetVariable vVrev, disable=0
				SetVariable vVrev,value= root:MD2dialog:SepPoNPulse
				break
			endif
			break
		case "cMainDisp":
			if (checked == 0)
				CheckBox cmaindisp, title="Display of analysis is switched off"
				CheckBox cdisp_I, disable=2
				CheckBox cdisp_Cm, disable=2
				CheckBox cdisp_Q, disable=2
				SetVariable vwtim_I, disable=1
				SetVariable vwtim_Cm, disable=1
				SetVariable vwtim_Q, disable=1
				SetDrawEnv textrgb=(30464,30464,30464)
			endif
			if (checked == 1)
				if (!md2_Get_ChBx_state("cdisp_I") && !md2_Get_ChBx_state("cdisp_Q") && !md2_Get_ChBx_state("cdisp_Cm"))
					CheckBox cdisp_I, value=1
					CheckBox cdisp_Q, value=1
					CheckBox cdisp_Cm, value=1
				endif
				CheckBox cmaindisp, title="Display of analysis is switched on"
				CheckBox cdisp_I, disable=0
				CheckBox cdisp_Cm, disable=0
				CheckBox cdisp_Q, disable=0
				SetVariable vwtim_I, disable=0
				SetVariable vwtim_Cm, disable=0
				SetVariable vwtim_Q, disable=0
			endif
			break
		case "cExclCrit":
			if (checked == 0)
				CheckBox cExclCrit, title="No data will be excluded"
				SetDrawEnv textrgb=(65435,65435,65435)
				DrawText 200,442,"at V(mV)"
				SetVariable vExclCurr, disable=1
			endif
			if (checked == 1)
				CheckBox cExclCrit, title="Exclude I(pA) >"
				SetVariable vExclCurr, disable=0
			endif
			break
		case "cStrg":
			if (checked == 0)
				CheckBox cStrg, title="Discard traces after analysis"
			endif
			if (checked == 1)
				CheckBox cStrg, title="Keep ICa / p/N traces"
			endif
			break
	endswitch
End

// ************************************************************************************************************************************

Function md2_swtchCntrl(CntrlName,checked) : CheckBoxControl
	String CntrlName
	Variable checked
	string ccase
	
	if (stringmatch(CntrlName,"clleak") || stringmatch(CntrlName,"cmleak"))
		ccase="leak"
	elseif (stringmatch(CntrlName,"cdisp_I") || stringmatch(CntrlName,"cdisp_Q") || stringmatch(CntrlName,"cdisp_Cm"))
		ccase="display"
	endif
		
	strswitch (ccase)
		case "leak":
			if (!md2_Get_ChBx_state("clleak") && !md2_Get_ChBx_state("cmleak"))
				CheckBox cMainLeak, value=0
				md2_MnChckbxCntrl("cMainLeak",0)
			endif
		break
		case "display":
			if (!md2_Get_ChBx_state("cdisp_I") && !md2_Get_ChBx_state("cdisp_Q") && !md2_Get_ChBx_state("cdisp_Cm"))
				CheckBox cMainDisp, value=0
				md2_MnChckbxCntrl("cMainDisp",0)
			endif
		break
	endswitch
End

// ************************************************************************************************************************************
// ** returns the value of a checkbox control

Function md2_Get_ChBx_state(name)

	string name
	ControlInfo $name
	return V_value
End

// ************************************************************************************************************************************
// ** Procedure for the wave selection list in the MD2Selector panel

Function md2_selector_ListBoxProc(lba) : ListBoxControl
	STRUCT WMListboxAction &lba

	Variable row = lba.row
	Variable col = lba.col
	WAVE/T/Z listWave = lba.listWave
	WAVE/Z selWave = lba.selWave
	switch( lba.eventCode )
		case -1: // control being killed
			break
		case 3: // double click
			if ((selwave[row][0]&16)>0)
				selwave[row][0]=selwave[row][0]&~16	//clear bit
			else
				selwave[row][0]=selwave[row][0]|16		//set bit
			endif
			break
		case 4: // cell selection
			NVAR CurrentsOnly=root:MD2dialog:CurrentsOnly
			NVAR MD2_RSeries=root:MD2dialog:MD2_RSeries
			NVAR MD2_Leak=root:MD2dialog:MD2_Leak
			NVAR MD2_RScomp=root:MD2dialog:MD2_RScomp
			NVAR MD2_Cslow=root:MD2dialog:MD2_Cslow
			NVAR MD2_Gain=root:MD2dialog:MD2_Gain
			NVAR MD2_VOffset=root:MD2dialog:MD2_VOffset
			string olddatafolder=getdatafolder(1)
			setdatafolder root:MD2allseries
			if (strlen(TraceNameList("MD2SelectorWin#G0",",",1))>0)
				do		// Remove traces from upper graph
					removefromgraph /W=MD2SelectorWin#G0 $StringFromList(0,TraceNameList("MD2SelectorWin#G0",";",1))
				while (strlen(TraceNameList("MD2SelectorWin#G0",",",1))>0)
			endif
			if (strlen(TraceNameList("MD2SelectorWin#G1",",",1))>0)
				do		// Remove traces from lower graph
					removefromgraph /W=MD2SelectorWin#G1 $StringFromList(0,TraceNameList("MD2SelectorWin#G1",";",1))
				while (strlen(TraceNameList("MD2SelectorWin#G1",",",1))>0)
			endif
			if (waveexists($listWave[row][1]+"_Cm"))
				if (Currentsonly)
					if (waveexists($listWave[row][1]+"_Gm"))
						AppendToGraph /C=(50000,50000,50000)/R/W=MD2SelectorWin#G0 $listWave[row][1]+"_Gm"
						label /W=MD2SelectorWin#G0 right "\Z06\u#2\s("+listWave[row][1]+"_Gm)\M Gm (nS)"
					endif
					if (waveexists($listWave[row][1]+"_Gs"))
						AppendToGraph /C=(50000,50000,50000)/R/W=MD2SelectorWin#G1 $listWave[row][1]+"_Gs"
						label /W=MD2SelectorWin#G1 right "\Z06\u#2\s("+listWave[row][1]+"_Gs)\M Gs (nS)"
					endif
					AppendToGraph /C=(65535,40000,40000)/W=MD2SelectorWin#G1 $listWave[row][1]+"_Cm"
				else
					if (waveexists($listWave[row][1]+"_Gm"))
						AppendToGraph /C=(40000,40000,40000)/R/W=MD2SelectorWin#G0 $listWave[row][1]+"_Gm"
						label /W=MD2SelectorWin#G0 right "\Z06\u#2\s("+listWave[row][1]+"_Gm)\M Gm (nS)"
					endif
					if (waveexists($listWave[row][1]+"_Gs"))
						AppendToGraph /C=(40000,40000,40000)/R/W=MD2SelectorWin#G1 $listWave[row][1]+"_Gs"
						label /W=MD2SelectorWin#G1 right "\Z06\u#2\s("+listWave[row][1]+"_Gs)\M Gs (nS)"
					endif
					AppendToGraph /W=MD2SelectorWin#G1 $listWave[row][1]+"_Cm"
				endif
				label /W=MD2SelectorWin#G1 left "\Z06\u#2\s("+listWave[row][1]+"_Cm)\M \F'Symbol'D\F'Arial'C\Bm\M (fF)"
			endif
			AppendToGraph /W=MD2SelectorWin#G0 $listWave[row][1]
			if (waveexists($listWave[row][1]+"_2"))	// Second channel was aquired
				AppendToGraph /C=(0,50000,0)/R/W=MD2SelectorWin#G1 $listWave[row][1]+"_2"
			endif
			label /W=MD2SelectorWin#G0 left "\Z06\u#2\s("+listWave[row][1]+")\M I\BCa\M (pA)"
			wave InWave=$listWave[row][1]
			MD2_RSeries=md2_getfromnote(InWave,"RSeries")
			ValDisplay MD2Selector_RSdisp value=#"root:MD2dialog:MD2_RSeries"
			MD2_Leak=round(1e14*mean(InWave,0,0.002))/100
			ValDisplay MD2Selector_Leakdis value=#"root:MD2dialog:MD2_Leak"
			MD2_RSComp=(1-(md2_getfromnote(InWave,"RSeries")-md2_getfromnote(InWave,"RSValue"))/md2_getfromnote(InWave,"RSeries"))*100
			ValDisplay MD2Selector_RScompdis value=#"root:MD2dialog:MD2_RSComp"
			MD2_Cslow=md2_getfromnote(InWave,"Cslow")
			ValDisplay MD2Selector_Cslowdis value=#"root:MD2dialog:MD2_Cslow"
			MD2_Gain=1e9*md2_getfromnote(InWave,"Gain")		//Why is this necessary?
			ValDisplay MD2Selector_Gaindis value=#"root:MD2dialog:MD2_Gain"
			MD2_VOffset=md2_getfromnote(InWave,"VOffset")
			ValDisplay MD2Selector_VOffsetdis value=#"root:MD2dialog:MD2_VOffset"
			ControlUpdate /A
			ControlInfo md2_showfromcheck
			If (V_Value)
				md2_adjustxrange()
			endif
			setdatafolder olddatafolder
		case 5: // cell selection plus shift key
			break
		case 6: // begin edit
			break
		case 7: // finish edit
			break
	endswitch

	return 0
End

// **********************************************************************************************************************
// ** Make the list of Waves which will be displayed in the MD2Selector window

function md2_MakeList()

NVAR CurrentsOnly=root:MD2dialog:CurrentsOnly
String MyList	
variable i,j

	string olddatafolder=getdatafolder(1)
	setdatafolder root:MD2allseries
	if (!Currentsonly)
		MyList=wavelist("*_Cm",";","")			// Take only those current traces which are accompanied by
		Make /O/T/N=0 root:MD2dialog:ListWave		//    a _Cm trace
		Make /O/N=0 root:MD2dialog:SelWave
		wave /T ListWave=root:MD2dialog:ListWave
		wave SelWave=root:MD2dialog:SelWave
		for (i=0;i<itemsinlist(MyList);i+=1)
			if (exists(removeending(stringfromlist(i,MyList),"_Cm"))==1)
				j+=1
				redimension /N=(j,2) ListWave
				redimension /N=(j,2) SelWave
				ListWave[j-1][1]=removeending(stringfromlist(i,MyList),"_Cm")
			endif
		endfor
		SelWave[][0]=32
	else
		MyList=wavelist("*_1",";","")			// Take all current traces
		Make /O/T/N=0 root:MD2dialog:ListWave
		Make /O/N=0 root:MD2dialog:SelWave
		wave /T ListWave=root:MD2dialog:ListWave
		wave SelWave=root:MD2dialog:SelWave
		for (i=0;i<itemsinlist(MyList);i+=1)
			j+=1
			redimension /N=(j,2) ListWave
			redimension /N=(j,2) SelWave
			ListWave[j-1][1]=removeending(stringfromlist(i,MyList),"_Cm")
		endfor
		SelWave[][0]=32
	endif
	setdatafolder olddatafolder
end

// **********************************************************************************************************************
// ** The window where you select which wave to analyze

function md2_SelectorWin() : Panel

	NVAR ShowFrom=root:MD2dialog:ShowFrom
	PauseUpdate; Silent 1		// building window...
	DoWindow /K MD2SelectorWin
	NewPanel /K=1 /W=(402,121,1109,688) /N=MD2SelectorWin
	ListBox MD2selector_ListBox,pos={4,5},size={201,511},proc=md2_selector_ListBoxProc
	ListBox MD2selector_ListBox,listWave=root:MD2dialog:ListWave,selWave=root:MD2dialog:SelWave,mode= 9
  	ListBox MD2selector_ListBox,widths={24,160}
	ValDisplay MD2Selector_RSdisp,pos={45,520},size={119,17},title="RSeries",frame=4,format="%g MOhm"
	ValDisplay MD2Selector_RSdisp,limits={10,38,30},barmisc={0,80},bodyWidth= 100,mode= 2,lowColor= (0,65280,0),zeroColor= (65280,65280,0), highcolor= (65280,0,0)
	ValDisplay MD2Selector_RSdisp,value= #"NaN"
  	ValDisplay MD2Selector_Leakdis,pos={9,545},size={142,17},title="Leak current"
	ValDisplay MD2Selector_Leakdis,frame=4,format="%g pA"
	ValDisplay MD2Selector_Leakdis,limits={-55,-20,-30},barmisc={0,80},bodyWidth= 100,mode= 2,lowColor= (65280,0,0),zeroColor= (65280,65280,0), highcolor= (0,65280,0)
	ValDisplay MD2Selector_Leakdis,value= #"NaN"
  	ValDisplay MD2Selector_RScompdis,pos={175,520},size={156,17},title="RSeries comp. ca."
	ValDisplay MD2Selector_RScompdis,frame=4,format="%g %"
	ValDisplay MD2Selector_RScompdis,limits={8,50,25},barmisc={0,70},bodyWidth= 70,mode= 2,lowColor= (0,65280,0),zeroColor= (65280,43520,0)
	ValDisplay MD2Selector_RScompdis,value= #"NaN"
  	ValDisplay MD2Selector_Cslowdis,pos={215,545},size={109,17},title="Cslow"
	ValDisplay MD2Selector_Cslowdis,frame=4,format="%g pF"
	ValDisplay MD2Selector_Cslowdis,limits={8,40,20},barmisc={0,70},bodyWidth= 70,mode= 2,lowColor= (0,65280,0),zeroColor= (65280,43520,0)
	ValDisplay MD2Selector_Cslowdis,value= #"NaN"
	ValDisplay MD2Selector_Gaindis,pos={318,520},size={100,17},title="Gain",frame=4,format="%g mV/pA"
  	ValDisplay MD2Selector_Gaindis,limits={8,40,20},barmisc={0,70},bodyWidth= 70,mode= 2,lowColor= (0,65280,0),zeroColor= (65280,43520,0)
	ValDisplay MD2Selector_Gaindis,value= #"NaN"
	ValDisplay MD2Selector_VOffsetdis,pos={308,545},size={113,17},title="VOffset"
	ValDisplay MD2Selector_VOffsetdis,frame=4,format="%g mV"
  	ValDisplay MD2Selector_VOffsetdis,limits={8,40,20},barmisc={0,70},bodyWidth= 70,mode= 2,lowColor= (0,65280,0),zeroColor= (65280,43520,0)
	ValDisplay MD2Selector_VOffsetdis,value= #"NaN"
	CheckBox md2_currentsonly ,pos={411,520}, title="Currents only mode", proc=md2_CurrentsOnlyCheckProc, variable=root:MD2dialog:CurrentsOnly
	CheckBox md2_currentsonly help={"Currents only mode allows analysis of ICa and QCa for non-lockin recordings, but will skip dCm analysis."}
	CheckBox md2_showfromcheck,pos={411,545},size={50,20},proc=md2_showfromCheckProc,variable=root:MD2dialog:ShowFrom
	CheckBox md2_showfromcheck,title=""
	SetVariable md2_showfromsetvar,pos={470,544},bodyWidth=40,disable=2,variable=root:MD2dialog:ShowFromStart,proc=md2_XRangeVar,limits={-inf,inf,0.1},title="show from"
	SetVariable md2_showtosetvar,pos={525,544},title="to",bodyWidth=40,disable=2,variable=root:MD2dialog:ShowFromEnd,proc=md2_XRangeVar,limits={-inf,inf,0.1}
	TitleBox md2_showfromtitle title="s",disable=2,frame=0,pos={580,545}
	if (ShowFrom)
		SetVariable md2_showfromsetvar disable=0
		SetVariable md2_showtosetvar disable=0
		TitleBox md2_showfromtitle disable=0
	endif
	Button MD2DoneButton,pos={600,522},size={100,40},title="Done", proc=md2_SelectorDoneButtonProc
	Display/W=(211,5,701,241)/HOST=#
	RenameWindow #,G0
	SetActiveSubwindow ##
  	Display/W=(212,248,699,514)/HOST=#
	RenameWindow #,G1
	SetActiveSubwindow ##
EndMacro

// **********************************************************************************************************************
// ** The Done button of the MD2Selector window

Function md2_SelectorDoneButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable i
	wave selwave=root:MD2dialog:SelWave
	wave /T ListWave=root:MD2dialog:ListWave
	SVAR MD2WaveList=root:MD2dialog:MD2WaveList
	switch( ba.eventCode )
		case 2: // mouse up
			MD2WaveList=""
			for (i=dimsize(selwave,0)-1;i>=0;i-=1)
				if ((selwave[i][0]&16)>0)
					MD2WaveList=AddListItem(ListWave[i][1],MD2WaveList,";")
				endif
			endfor
			DoWindow /K MD2SelectorWin
			TitleBox md2_numofseries title="Series selected: "+num2str(itemsinlist(MD2WaveList))+" of "+num2str(dimsize(ListWave,0)), win=MD2UserDialog
			break
	endswitch

	return 0
End

// **********************************************************************************************************************
// ** Main analysis

Function md2_Analyze()

	print "\r\rMACRO MultiDepol 2:", date(), "\rBegin:",time(), "\r"


	md2_Analysis_Folders()
	md2_Set_Analysis_Variables("all")
	
	
	SVAR suffix=root:MD2dialog:suffix
	SVAR info=root:MD2dialog:info
	NVAR skpt=root:MD2dialog:skpt, avgtb=root:MD2dialog:avgtb, avgta=root:MD2dialog:avgta
	NVAR cnstb=root:MD2dialog:cnstb, cnsta=root:MD2dialog:cnsta
	NVAR Vlj=root:MD2dialog:Vlj, Vrev=root:MD2dialog:Vrev, Vhold=root:MD2dialog:Vhold
	NVAR doleakcorr=root:MD2dialog:doleakcorr
	NVAR offsett=root:MD2dialog:offsett
	NVAR leaktype=root:MD2dialog:leaktype
	NVAR TwoChan=root:MD2dialog:TwoChan
	NVAR CurrentsOnly=root:MD2dialog:CurrentsOnly
	SVAR CurrAnaFolder=root:MD2temp:CurrAnaFolder
	SVAR sufx=root:MD2temp:sufx
	SVAR cmdstr=root:MD2temp:cmdstr
	SVAR cmwavname=root:MD2temp:cmwavname, iwavname=root:MD2temp:iwavname
	SVAR actualdate=root:MD2temp:actualdate
	SVAR none=root:MD2temp:none, twadjststr=root:MD2temp:twadjststr
	SVAR twiICa=root:MD2temp:twiICa, twfICa=root:MD2temp:twfICa
	SVAR firstdate=root:MD2temp:firstdate, lastdate=root:MD2temp:lastdate
	SVAR SortedWavesStr=root:MD2temp:SortedWavesStr, WavesNotSortedStr=root:MD2temp:WavesNotSortedStr
	SVAR PNfoldername=root:MD2temp:PNfoldername
	SVAR Datfile = root:MD2dialog:Datfile
	SVAR MD2WaveList=root:MD2dialog:MD2WaveList
	NVAR DoBin=root:MD2dialog:DoBin
	NVAR DoSlopeCor=root:MD2dialog:DoSlopeCor
	NVAR n_files=root:MD2temp:n_files
	NVAR tskp=root:MD2temp:tskp, maxavgtb=root:MD2temp:maxavgtb, maxavgta=root:MD2temp:maxavgta
	NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta 
	NVAR V_rev=root:MD2temp:V_rev, V_lj=root:MD2temp:V_lj
	NVAR depcnt=root:MD2temp:depcnt, c=root:MD2temp:c, indx=root:MD2temp:indx
	NVAR maxdepnum=root:MD2temp:maxdepnum
	NVAR actualtime=root:MD2temp:actualtime
	NVAR samplefreq=root:MD2temp:samplefreq
	NVAR toffset=root:MD2temp:toffset
	NVAR /c dCm=root:MD2temp:dCm
	NVAR depdur=root:MD2temp:depdur
	NVAR deppot=root:MD2temp:deppot
	NVAR twadjust=root:MD2temp:twadjust
	NVAR iI_left=root:MD2temp:iI_left, iI_right=root:MD2temp:iI_right
	NVAR fI_left=root:MD2temp:fI_left, fI_right=root:MD2temp:fI_right
	NVAR ICa_i=root:MD2temp:ICa_i
	NVAR ICa_f=root:MD2temp:ICa_f
	NVAR Ipeak=root:MD2temp:Ipeak
	NVAR t_peak=root:MD2temp:t_peak
	NVAR q_real=root:MD2temp:q_real
	NVAR q_virt=root:MD2temp:q_virt
	NVAR cnt=root:MD2temp:cnt
	NVAR pdCm_smoothfactor=root:MD2temp:pdCm_smoothfactor, iICa_smoothfactor=root:MD2temp:iICa_smoothfactor
	NVAR hl_left=root:MD2temp:hl_left, hl_right=root:MD2temp:hl_right
	NVAR xcsweepno=root:MD2temp:xcsweepno
	WAVE nanpot=root:MD2temp:nanpot
	NVAR PatchMaster=root:MD2dialog:PatchMaster
	variable serbegin,serend
	string customleakname
	if (TwoChan)
		NVAR q_post=root:MD2temp:q_post
	endif
	
	sufx="_"+suffix
	tskp=skpt/1000; maxavgtb=avgtb/1000; maxavgta=avgta/1000; tcnstb=cnstb/1000; tcnsta=cnsta/1000
	V_lj=Vlj/1000; V_rev=(Vrev/1000)+V_lj
	indx=0
	
	n_files = itemsinlist(MD2WaveList,";")															//number of lock-in waves
	print "\r  "+num2str(n_files),"sweeps to analyze...\r"

	SetDataFolder $CurrAnaFolder
	make /o /t $"infowave"+sufx
	Note $"infowave"+sufx, "Created by MultiDepol macro version: "+MDVersion
	make /o /N=(n_files) /t $"wavesstructures"+sufx
	Note $"wavesstructures"+sufx, "Created by MultiDepol macro version: "+MDVersion
		
	ControlInfo /W=MD2UserDialog cXCa


	WAVE /T wavesstructures=$(CurrAnaFolder+":wavesstructures"+sufx)
	WAVE /T infowave=$(CurrAnaFolder+":infowave"+sufx)
	WAVE /C cm_NaNwav=root:MD2temp:cm_NaNwav
	WAVE /C cm_plus_NaNwav=root:MD2temp:cm_plus_NaNwav
	WAVE /C I_NaNwav=root:MD2temp:I_NaNwav											//this wave stores all start- and end-points of the sweep's sine waves

	
	SetDataFolder $CurrAnaFolder
	


	do
		depcnt=1; c=0
		print "--> sweep no",indx+1, "  (", n_files-indx-1,"sweeps remaining  )"
		
		iwavname=stringfromlist(indx,MD2WaveList,";")
		cmwavname=stringfromlist(indx,MD2WaveList,";")+"_Cm"

		SetDataFolder root:MD2temp
		duplicate /O $"root:MD2allseries:"+iwavname $"root:MD2temp:"+iwavname
		if (!(CurrentsOnly) || waveexists($"root:MD2allseries:"+cmwavname))
			duplicate /O $"root:MD2allseries:"+cmwavname $"root:MD2temp:"+cmwavname
		endif
		if (waveexists($"root:MD2allseries:"+iwavname+"_leak"))
			duplicate /O $"root:MD2allseries:"+iwavname+"_leak" $"root:MD2temp:"+iwavname+"_leak"
		endif
		duplicate /O $"root:MD2allseries:"+iwavname+"_stim" $"root:MD2temp:"+iwavname+"_stim"
		if (PatchMaster&&waveexists($"root:MD2allseries:"+cmwavname))
			wave CurrentCmWave=$cmwavname
			CurrentCmWave=CurrentCmWave[p]==0 ? NaN : CurrentCmWave[p]	//PM exports Cm traces as 0 during depol
		endif
		if (TwoChan&&waveexists($"root:MD2allseries:"+iwavname+"_2"))
			duplicate /O  $"root:MD2allseries:"+iwavname+"_2" $"root:MD2temp:"+iwavname+"_2"
		endif
				
		SetDataFolder $CurrAnaFolder
		
		serend = strsearch(iwavname,"_",inf,1)
		serbegin = strsearch(iwavname,"_",serend-1,1)
		PNfoldername = iwavname[0,serend]
		xcsweepno = str2num(iwavname[serbegin+1,serend-1])
		
		newdatafolder /O/S $CurrAnaFolder+":PoN:"+PNfoldername
		
		duplicate /O $"root:MD2allseries:"+iwavname $CurrAnaFolder+":PoN:"+PNfoldername+":"+iwavname
		if (!(CurrentsOnly) || waveexists($"root:MD2allseries:"+cmwavname))
			duplicate /O $"root:MD2allseries:"+cmwavname $CurrAnaFolder+":PoN:"+PNfoldername+":"+cmwavname
		endif
		if (waveexists($"root:MD2allseries:"+iwavname+"_leak"))
			duplicate /O $"root:MD2allseries:"+iwavname+"_leak" $CurrAnaFolder+":PoN:"+PNfoldername+":"+iwavname+"_leak"
		endif
		duplicate /O $"root:MD2allseries:"+iwavname+"_stim" $CurrAnaFolder+":PoN:"+PNfoldername+":"+iwavname+"_stim"

		SetDataFolder $CurrAnaFolder

		if (!(CurrentsOnly) || waveexists($"root:MD2allseries:"+cmwavname))
			MD2_get_NaN_times(root:MD2temp:$cmwavname)								// list the number and times of sinewave / depol elements in the sweep
		else
			MD2_get_depol_times(root:MD2temp:$iwavname)
		endif

		SetDataFolder $CurrAnaFolder
		do 																	// create the wavesstructures wave giving details about sine / depol elements
			c+=1
			if (c==1)
//				wavesstructures[indx] = "(sweep " + iwavname[0, strlen(iwavname)-5] + "): sine" + num2str(c) + ": "  +  num2str(real(cm_NaNwav[c])) + "-" +  num2str(imag(cm_NaNwav[c])) + "  dep" +  num2str(c)
				// changed to write the entire name of the sweep
				wavesstructures[indx] = "(sweep " + iwavname + "): sine" + num2str(c) + ": "  +  num2str(real(cm_NaNwav[c])) + "-" +  num2str(imag(cm_NaNwav[c])) + "  dep" +  num2str(c)
				wavesstructures[indx] += "+cnsts: "  + num2str(imag(cm_plus_NaNwav[c])) + "-" + num2str(real(cm_plus_NaNwav[c+1])) + "  sine" + num2str(c+1) + ": "  +  num2str(real(cm_NaNwav[c+1])) + "-" +  num2str(imag(cm_NaNwav[c+1])) + "    "
			else
				wavesstructures[indx] += "  dep" +  num2str(c) + "+cnsts: "  + num2str(imag(cm_plus_NaNwav[c])) + "-" + num2str(real(cm_plus_NaNwav[c+1]))+"  sine"+num2str(c+1)+": "+num2str(real(cm_NaNwav[c+1]))+"-"+num2str(imag(cm_NaNwav[c+1]))+"    "
			endif
		while (c<cm_NaNwav[0])												// (cm_NaNwav[0] is the number of depols

		if (cm_NaNwav[0] > maxdepnum)
			md2_make_waves(2,"sweep")										//will provide information about origin of data		X
			md2_make_waves(1,"rtim")										//time of each sweep in relative time				X	
			md2_make_waves(3,"ddur")										//duration of depolarization						X
			md2_make_waves(3,"dpot")										//potential of depolarization						X
			md2_make_waves(1,"relpot")										//potential of depolarization	 as stored in pulse file (relevant potential) X
			md2_make_waves(3,"dCms")										//deltaCm "short average": averaging time limited to the time remaining in the interdepol segment after skipping	X
			md2_make_waves(3,"dCml")										//deltaCm "long average": averaging time only limited by the user defined maxavrgtime						X
			md2_make_waves(3,"iICa")										//initial Ca current in early timewindow given in get_ICa-function		X
			md2_make_waves(3,"fICa")										//final Ca current in late timewindow given in get_ICa-function		X
			md2_make_waves(3,"pICa")										//peak current during depol, independent of timewindow for iICa
			md2_make_waves(3,"tpeak")										//time of peak current relativ (+) to beginning of depol
			md2_make_waves(3,"Qreal")										//real (arithmetic integral of the first Ca-current)	X		
			md2_make_waves(3,"Qvirt")										//virtual integral (peak current * pulse duration)	X
			md2_make_waves(1,"hpot")										//holding potential
			md2_make_waves(2,"atim")										//time of each sweep in absolute time
			md2_make_waves(1,"Rs")											//Rs at the time of the pulse
			md2_make_waves(1,"Tp")											//temperature
			        									
			if (DoSlopeCor)
				md2_make_waves(3,"dCms_c")								//dCms from trace that has been corrected for slope of initial segment
				md2_make_waves(3,"dCml_c")									//dCml from trace that has been corrected for slope of initial segment
			endif
			if (doleakcorr == 1)
				md2_make_waves(3,"ileak_h")									//"holding leak": leak current during constant at holding potential preceeding each depol	X	
				md2_make_waves(3,"ileak_d")									//leak current during depol, calculated as line through 'holding leak' and Vrev 				X
				md2_make_waves(3,"iICa_l")									//	leak corrected current 	X
				md2_make_waves(3,"fICa_l")									//	leak corrected current 	X
				md2_make_waves(3,"pICa_l")									//	leak corrected current 	X
				md2_make_waves(3,"Qreal_l")									//real (arithmetic integral of the first Ca-current), "linear leak"-correction 	X
				md2_make_waves(3,"Qvirt_l")									//virtual integral (average current * pulse duration), "linear leak"-correction	X
			endif
			if (cm_NaNwav[0] >= 2)
				md2_make_waves(1,"Cmsrat")										//	X
				md2_make_waves(1,"Cmlrat")						
				md2_make_waves(1,"bmaxs")										//	X				
				md2_make_waves(1,"bmaxl")
				md2_make_waves(1,"Cmssum")										//	X		
				md2_make_waves(1,"Cmlsum")
				md2_make_waves(1,"iIrat")											//	X	
				md2_make_waves(1,"fIrat")
				md2_make_waves(1,"rQrat")
				md2_make_waves(1,"vQrat")
				md2_make_waves(1,"rQsum")										//	X	
				md2_make_waves(1,"vQsum")										//	X	
				md2_make_waves(1,"dintv")											//interdepol interval	X
				if (doleakcorr == 1)
					md2_make_waves(1,"iIrat_l")
					md2_make_waves(1,"fIrat_l")
					md2_make_waves(1,"rQsum_l")
					md2_make_waves(1,"vQsum_l")
					md2_make_waves(1,"rQrat_l")
					md2_make_waves(1,"vQrat_l")
				endif
			endif
			if (TwoChan == 1)													// Analyze postsynaptic recording from second channel
				md2_make_waves(3,"Qpost")
			endif
			maxdepnum = cm_NaNwav[0]
		endif


		WAVE /T cellsweep=$(CurrAnaFolder+":sweep"+sufx), atim=$(CurrAnaFolder+":atim"+sufx)
		WAVE rtim=$(CurrAnaFolder+":rtim"+sufx)
		WAVE hpot=$(CurrAnaFolder+":hpot"+sufx)
		WAVE relpot = $(CurrAnaFolder+":relpot" + sufx)
		WAVE Rs = $(CurrAnaFolder+":Rs" + sufx)
		WAVE Tp=$(CurrAnaFolder+":Tp"+sufx)						

		if (cm_NaNwav[0] >= 2)		// if more than one depol per sweep
			WAVE dintv=$(CurrAnaFolder+":dintv"+sufx)
			dintv[indx] = (imag(cm_plus_NaNwav[2])) - (real(cm_plus_NaNwav[2])) + tcnstb + tcnsta
		endif
		
		cellsweep[indx] = suffix + "/" + iwavname[(strsearch(iwavname,"_",0)+1), (strsearch(iwavname,"_",(strsearch(iwavname,"_",0)+1))-1)]
		
		Rs[indx]=MD2_getfromnote($"root:MD2temp:"+iwavname,"RSeries")

		Tp[indx] = MD2_getfromnote($"root:MD2temp:"+iwavname, "Temperature")			// TODO:(?) This does not appear to work the way it should...

		atim[indx] = MD2_getstringfromnote($"root:MD2temp:"+iwavname, "Timer")
//		rtim[indx] = MD2_gettimefromnote($"root:MD2temp:"+iwavname, "Timer") + toffset
		rtim[indx] = MD2_gettimefromnote($"root:MD2temp:"+iwavname, "Timer")
		actualdate = md2_getstringfromnote($"root:MD2temp:"+iwavname, "Sweep time")
		actualtime = MD2_gettimefromnote($"root:MD2temp:"+iwavname, "Timer")
		samplefreq = dimdelta($"root:MD2temp:"+iwavname, 0)

		md2_compare_times()
		
		hpot[indx] = md2_getfromnote($"root:MD2temp:"+iwavname,"Holding") / 1000 + V_lj	//Get holding potential from wave note

		relpot[indx] =NaNpot[1]

		if (!CurrentsOnly)																//Only get dCm data when not using CurrentsOnly mode
			do																		// get deltaCm for all depols of current sweep
				WAVE dCml=$(CurrAnaFolder+":dCml" + num2str(depcnt) + sufx)
				WAVE dCms=$(CurrAnaFolder+":dCms" + num2str(depcnt) + sufx)
	
				dCm=md2_get_deltaCm($"root:MD2temp:"+cmwavname, depcnt)
				dCml[indx] = real(dCm)												//capacitance calculation stored in 'dCm'-wave
				dCms[indx] = imag(dCm)												//capacitance calculation stored in 'pdCm'-wave
				
				if (DoSlopeCor)
					WAVE dCml_c=$(CurrAnaFolder+":dCml_c" + num2str(depcnt) + sufx)
					WAVE dCms_c=$(CurrAnaFolder+":dCms_c" + num2str(depcnt) + sufx)
					
					dCm=md2_get_deltaCm_cor($"root:MD2temp:"+cmwavname, depcnt)
					dCml_c[indx] = real(dCm)											//capacitance calculation stored in 'dCm'-wave
					dCms_c[indx] = imag(dCm)										//capacitance calculation stored in 'pdCm'-wave
				endif
				depcnt += 1
			while (depcnt<=real(cm_NaNwav[0]))
		endif
					
		depcnt = 1	

		do
			WAVE ddur = $(CurrAnaFolder+":ddur" + num2str(depcnt) + sufx) 
			WAVE dpot = $(CurrAnaFolder+":dpot" + num2str(depcnt) + sufx)
			WAVE iICa = $(CurrAnaFolder+":iICa" + num2str(depcnt) + sufx)
			WAVE fICa = $(CurrAnaFolder+":fICa" + num2str(depcnt) + sufx)
			WAVE pICa = $(CurrAnaFolder+":pICa" + num2str(depcnt) + sufx)
			WAVE tpeak = $(CurrAnaFolder+":tpeak" + num2str(depcnt) + sufx)
			WAVE Qreal = $(CurrAnaFolder+":Qreal" + num2str(depcnt) + sufx)
			WAVE Qvirt = $(CurrAnaFolder+":Qvirt" + num2str(depcnt) + sufx)
			if (TwoChan)
				WAVE Qpost = $(CurrAnaFolder+":Qpost" + num2str(depcnt) + sufx)
			endif

			if (real(I_NaNwav[0]) == 0)													// if not true, nan-times detected a 0ms depol
	
				ddur[indx] = round(1e6*(real(cm_plus_NaNwav[depcnt+1]) - imag(cm_plus_NaNwav[depcnt]) - tcnstb - tcnsta))*1e-6  //ddur is depol time in s rounded to ms 
	
				depdur=ddur[indx]
			
				dpot[indx] = nanpot[depcnt] + 1000*V_lj  - 1000*md2_get_RsError(root:MD2temp:$(iwavname), depcnt)					// dpot is depol potential in mV corrected for liquid junction potential and RSeries
				deppot=(dpot[indx] / 1000)												// current depol potential in V corrected for liquid junction potential

				md2_get_ICa(root:MD2temp:$(iwavname), depcnt)
				md2_get_QCa(root:MD2temp:$(iwavname), depcnt)
				if (TwoChan)
					md2_get_Qpost(root:MD2temp:$(iwavname), depcnt)
				endif
	
				if (twadjust==1)
					none=""
//					twadjststr += iwavname[strsearch(iwavname,"_",strsearch(iwavname,"_",0)+1), strsearch(iwavname,"_",strsearch(iwavname,"_",strsearch(iwavname,"_",0)+1)+1)] + "/" + num2str(depcnt) + " "
					twadjststr += iwavname + "/" + num2str(depcnt) + " "		// changed to print the entire name of the sweep
				else
					twiICa = num2str(iI_left*1000) + " / " + num2str(iI_right*1000)
					twfICa = num2str(fI_left*1000) + " / " + num2str(fI_right*1000)
				endif
			
				iICa[indx] = ICa_i
				fICa[indx] = ICa_f
				pICa[indx] = Ipeak
				tpeak[indx] = t_peak
				Qreal[indx] = q_real
				Qvirt[indx] = q_virt
				if (TwoChan)
					Qpost[indx] = q_post
				endif
				if (doleakcorr==1)
					NVAR h_ileak=root:MD2temp:h_ileak
					NVAR d_ileak=root:MD2temp:d_ileak
					NVAR ICa_i_l=root:MD2temp:ICa_i_l
					NVAR ICa_f_l=root:MD2temp:ICa_f_l
					NVAR Ipeak_l=root:MD2temp:Ipeak_l
					NVAR q_real_l=root:MD2temp:q_real_l
					NVAR q_virt_l=root:MD2temp:q_virt_l
	
					WAVE ileak_h = $(CurrAnaFolder+":ileak_h" + num2str(depcnt) + sufx)
					WAVE ileak_d = $(CurrAnaFolder+":ileak_d" + num2str(depcnt) + sufx)
					WAVE iICa_l = $(CurrAnaFolder+":iICa_l" + num2str(depcnt) + sufx)
					WAVE fICa_l = $(CurrAnaFolder+":fICa_l" + num2str(depcnt) + sufx)
					WAVE pICa_l = $(CurrAnaFolder+":pICa_l" + num2str(depcnt) + sufx)
					WAVE Qreal_l = $(CurrAnaFolder+":Qreal_l" + num2str(depcnt) + sufx)
					WAVE Qvirt_l = $(CurrAnaFolder+":Qvirt_l" + num2str(depcnt) + sufx)
	
					ileak_h[indx] = h_ileak
					ileak_d[indx] = d_ileak
					iICa_l[indx] = ICa_i_l
					fICa_l[indx] = ICa_f_l
					pICa_l[indx] = Ipeak_l
					Qreal_l[indx] = q_real_l
					Qvirt_l[indx] = q_virt_l
				endif				
			else																		// in case depol = 0ms
				ddur[indx] = 0
	
				depdur=ddur[indx]

				dpot[indx] = nanpot[depcnt]
				deppot=(dpot[indx] / 1000)
				
				if (TwoChan)
					md2_get_Qpost(root:MD2temp:$(iwavname), depcnt)
					Qpost[indx] = q_post
				endif
				
				iICa[indx] = NaN
				fICa[indx] = NaN
				pICa[indx] = NaN
				tpeak[indx] = NaN
				Qreal[indx] = NaN
				Qvirt[indx] = NaN
				if (doleakcorr==1)
					NVAR h_ileak=root:MD2temp:h_ileak
					NVAR d_ileak=root:MD2temp:d_ileak
					NVAR ICa_i_l=root:MD2temp:ICa_i_l
					NVAR ICa_f_l=root:MD2temp:ICa_f_l
					NVAR Ipeak_l=root:MD2temp:Ipeak_l
					NVAR q_real_l=root:MD2temp:q_real_l
					NVAR q_virt_l=root:MD2temp:q_virt_l
	
					WAVE ileak_h = $(CurrAnaFolder+":ileak_h" + num2str(depcnt) + sufx)
					WAVE ileak_d = $(CurrAnaFolder+":ileak_d" + num2str(depcnt) + sufx)
					WAVE iICa_l = $(CurrAnaFolder+":iICa_l" + num2str(depcnt) + sufx)
					WAVE fICa_l = $(CurrAnaFolder+":fICa_l" + num2str(depcnt) + sufx)
					WAVE pICa_l = $(CurrAnaFolder+":pICa_l" + num2str(depcnt) + sufx)
					WAVE Qreal_l = $(CurrAnaFolder+":Qreal_l" + num2str(depcnt) + sufx)
					WAVE Qvirt_l = $(CurrAnaFolder+":Qvirt_l" + num2str(depcnt) + sufx)
	
					ileak_h[indx] = NaN
					ileak_d[indx] = NaN
					iICa_l[indx] = NaN
					fICa_l[indx] = NaN
					pICa_l[indx] = NaN
					Qreal_l[indx] = NaN
					Qvirt_l[indx] = NaN
				endif				
			
			endif
			depcnt += 1
		while (depcnt<=real(cm_NaNwav[0]))


		if (cm_NaNwav[0] >= 2)				// TEMP postsyn por multiple depols not implemented yet.
			WAVE dCml1=$(CurrAnaFolder+":dCml1" + sufx)
			WAVE dCms1=$(CurrAnaFolder+":dCms1" + sufx)
			WAVE dCml2=$(CurrAnaFolder+":dCml2" + sufx)
			WAVE dCms2=$(CurrAnaFolder+":dCms2" + sufx)
			WAVE Cmsrat = $(CurrAnaFolder+":Cmsrat"+sufx)
			WAVE Cmlrat = $(CurrAnaFolder+":Cmlrat"+sufx)
			WAVE Cmssum = $(CurrAnaFolder+":Cmssum"+sufx)
			WAVE Cmlsum = $(CurrAnaFolder+":Cmlsum"+sufx)
			WAVE bmaxs = $(CurrAnaFolder+":bmaxs"+sufx)
			WAVE bmaxl = $(CurrAnaFolder+":bmaxl"+sufx)
			WAVE iIrat = $(CurrAnaFolder+":iIrat"+sufx)
			WAVE fIrat = $(CurrAnaFolder+":fIrat"+sufx)
			WAVE rQsum = $(CurrAnaFolder+":rQsum"+sufx)
			WAVE vQsum = $(CurrAnaFolder+":vQsum"+sufx)
			WAVE rQrat = $(CurrAnaFolder+":rQrat"+sufx)
			WAVE vQrat = $(CurrAnaFolder+":vQrat"+sufx)
			WAVE iICa1 = $(CurrAnaFolder+":iICa1" + sufx)
			WAVE fICa1 = $(CurrAnaFolder+":fICa1" + sufx)
			WAVE iICa2 = $(CurrAnaFolder+":iICa2" + sufx)
			WAVE fICa2 = $(CurrAnaFolder+":fICa2" + sufx)
			WAVE Qreal1 = $(CurrAnaFolder+":Qreal1" + sufx)
			WAVE Qvirt1 = $(CurrAnaFolder+":Qvirt1" + sufx)
			WAVE Qreal2 = $(CurrAnaFolder+":Qreal2" + sufx)
			WAVE Qvirt2 = $(CurrAnaFolder+":Qvirt2" + sufx)

			Cmsrat[indx] = dCms2 / dCms1
			Cmlrat[indx] = dCml2 / dCml1
			Cmssum[indx] = dCms2 + dCms1
			Cmlsum[indx] = dCml2 + dCml1
			bmaxs[indx] = Cmssum / Cmsrat
			bmaxl[indx] = Cmlsum / Cmlrat
			iIrat[indx] = iICa2 / iICa1
			fIrat[indx] = fICa2 / fICa1
			rQsum[indx] = Qreal1 + Qreal2
			vQsum[indx] = Qvirt1 + Qvirt2
			rQrat[indx] = Qreal2 / Qreal1
			vQrat[indx] = Qvirt2 / Qvirt1
			
			if (doleakcorr==1)
				WAVE iIrat_l = $(CurrAnaFolder+":iIrat_l"+sufx)
				WAVE fIrat_l = $(CurrAnaFolder+":fIrat_l"+sufx)
				WAVE rQsum_l = $(CurrAnaFolder+":rQsum_l"+sufx)
				WAVE vQsum_l = $(CurrAnaFolder+":vQsum_l"+sufx)
				WAVE rQrat_l = $(CurrAnaFolder+":rQrat_l"+sufx)
				WAVE vQrat_l = $(CurrAnaFolder+":vQrat_l"+sufx)
				WAVE iICa_l1 = $(CurrAnaFolder+":iICa_l1" + sufx)
				WAVE fICa_l1 = $(CurrAnaFolder+":fICa_l1" + sufx)
				WAVE iICa_l2 = $(CurrAnaFolder+":iICa_l2" + sufx)
				WAVE fICa_l2 = $(CurrAnaFolder+":fICa_l2" + sufx)
				WAVE Qreal_l1 = $(CurrAnaFolder+":Qreal_l1" + sufx)
				WAVE Qvirt_l1 = $(CurrAnaFolder+":Qvirt_l1" + sufx)
				WAVE Qreal_l2 = $(CurrAnaFolder+":Qreal_l2" + sufx)
				WAVE Qvirt_l2 = $(CurrAnaFolder+":Qvirt_l2" + sufx)

				iIrat_l[indx] =  iICa_l2 / iICa_l1
				fIrat_l[indx] = fICa_l2 / fICa_l1
				rQsum_l[indx] = Qreal_l1 + Qreal_l2
				vQsum_l[indx] = Qvirt_l1 +Qvirt_l2
				rQrat_l[indx] = Qreal_l2 / Qreal_l1
				vQrat_l[indx] = Qvirt_l2 / Qvirt_l1
			endif
		endif
		
		if (md2_Get_ChBx_state("cExclCrit"))
			NVAR ExclCurr=root:MD2dialog:ExclCurr
			NVAR hl_left=root:MD2temp:hl_left, hl_right=root:MD2temp:hl_right	
			variable stx = imag(cm_plus_NaNwav[1]) + tcnstb
			if ((mean($"root:MD2temp:"+iwavname,stx-hl_left, stx-hl_right)*1e12)<ExclCurr)
				print "Excluding "+iwavname+" from results: Leak current is",mean($"root:MD2temp:"+iwavname,stx-hl_left, stx-hl_right)*1e12,"nA, exclusion threshold is",ExclCurr,"nA."
				iICa[indx] = NaN
				fICa[indx] = NaN
				pICa[indx] = NaN
				tpeak[indx] = NaN
				Qreal[indx] = NaN
				Qvirt[indx] = NaN
				if (doleakcorr==1)
					iICa_l[indx] = NaN
					fICa_l[indx] = NaN
					pICa_l[indx] = NaN
					Qreal_l[indx] = NaN
					Qvirt_l[indx] = NaN
				endif
				if (cm_NaNwav[0] >= 2)
					Cmsrat[indx] = NaN
					Cmlrat[indx] = NaN
					Cmssum[indx] = NaN
					Cmlsum[indx] = NaN
					bmaxs[indx] = NaN
					bmaxl[indx] = NaN
					iIrat[indx] = NaN
					fIrat[indx] = NaN
					rQsum[indx] = NaN
					vQsum[indx] = NaN
					rQrat[indx] = NaN
					vQrat[indx] = NaN
					if (doleakcorr==1)
						iIrat_l[indx] = NaN
						fIrat_l[indx] = NaN
						rQsum_l[indx] = NaN
						vQsum_l[indx] = NaN
						rQrat_l[indx] = NaN
						vQrat_l[indx] = NaN
					endif
				endif
			endif
		endif
		killwaves /Z $cmwavname, $iwavname

		indx += 1
	while (indx<n_files)

	md2_sort_waves()			// Sort the data in the order in which it was acquired by Pulse
	

	InsertPoints 0,2, wavesstructures
	wavesstructures[0] = "this waves stores the (time-) structure of each sweep [sec]"

	cnt=0; infowave[cnt] = "Information about cell: " + info
	cnt+=1; infowave[cnt] = "Date and time of experiment: " + firstdate + " to " + lastdate
	cnt+=1; infowave[cnt] = "Date and time of macro-analysis:  " + date() + ", " + time()
	cnt+=1; infowave[cnt] = "Path to Pulse-file: " +  datfile
	cnt+=1; infowave[cnt] = "Number of sweeps analyzed: " + num2str(n_files)
	cnt+=1; infowave[cnt] = "Max. number of depols per sweep: " + num2str(maxdepnum)
	cnt+=2; infowave[cnt] = "user dialog defined settings:"

	cnt+=1; infowave[cnt] = "Alternate leak correction? (1=yes; 2=no): " + num2str(doleakcorr)
	if (doleakcorr == 1)
		if (leaktype == 1)
			infowave[cnt] += ", 'linear leak correction'"
		elseif (leaktype == 2)
		 	infowave[cnt] += ", 'separate leak pulses''"
		endif
	else
		infowave[cnt] += ", no additional leak correction"
	endif
	if (md2_Get_ChBx_state("md2_ZeroSubtract_ChkBox"))
		cnt+=1; infowave[cnt] = "Zero currents have been subtracted"
	else
		cnt+=1; infowave[cnt] = "Zero currents have NOT been subtracted"
	endif
	cnt+=1; infowave[cnt] = "Time skipped after depols (msec): " + num2str(tskp*1000)
	cnt+=1; infowave[cnt] = "Max. Cm-average-time before/after depol (msec): " + num2str(maxavgtb*1000) + " / " + num2str(maxavgta*1000)
	cnt+=1; infowave[cnt] = "Length of pre-/postdepol constants at holding potential (msec): pre =" + num2str(tcnstb*1000) + ", post ="+ num2str(tcnsta*1000)
	cnt+=1; infowave[cnt] = "Reversal potential of leak current, corrected for liquid junction potential (mV): " + num2str(V_rev*1000)
	cnt+=1; infowave[cnt] = "Liquid junction potential (mV): " + num2str(V_lj*1000)
	cnt+=2; infowave[cnt] = "internal constants of macro:"
	cnt+=1; infowave[cnt] = "factor for smoothing current wave (iICa calculation): " + num2str(iICa_smoothfactor)
	cnt+=1; infowave[cnt] = "Measuring iICa: left/right border of timewindow relative (+) to begin of depol (msec): " + twiICa
	cnt+=1; infowave[cnt] = "Measuring fICa: left/right border of timewindow relative (-) to end of depol (msec): " + twfICa
	cnt+=1; infowave[cnt] = "Measuring Ileak_h: left/right border of timewindow relative (-) to begin of depol (msec): " + num2str(hl_left*1000) + " / " + num2str(hl_right*1000)
	cnt+=1; infowave[cnt] = twadjststr + none
	cnt+=2; infowave[cnt] = "Waves in root-folder that have been sorted for original time order: " + SortedWavesStr
	cnt+=1; infowave[cnt] = "Waves in root-folder that have not been sorted for original time order: " + WavesNotSortedStr
	if (md2_Get_ChBx_state("md2_SlopeCorr_Chkbox"))
		cnt+=1; infowave[cnt] = "WARNING! Experimental slope correction was ON"
	endif
	
	if (!md2_Get_ChBx_state("cStrg"))
		setdatafolder $CurrAnaFolder
		killDataFolder PoN
		killDataFolder Currents
	endif
	
	if (DoBin)					// call the binvalues macro to bin all data to depol duration, if desired
		variable bincounter
		string commandstr
		for (bincounter=1;bincounter<maxdepnum+1;bincounter+=1)
			commandstr="binvalues(\"ddur"+num2str(bincounter)+sufx+"\",\"dCms"+num2str(bincounter)+sufx+"\",\"dCml"+num2str(bincounter)+sufx+"\",\"iICa"+num2str(bincounter)+sufx+"\",\"fICa"+num2str(bincounter)+sufx+"\",\"one x one bin\",15);DoWindow /K $winname(0,1)"
			execute commandstr
			commandstr="binvalues(\"ddur"+num2str(bincounter)+sufx+"\",\"pICa"+num2str(bincounter)+sufx+"\",\"tpeak"+num2str(bincounter)+sufx+"\",\"Qreal"+num2str(bincounter)+sufx+"\",\"Qvirt"+num2str(bincounter)+sufx+"\",\"one x one bin\",15);DoWindow /K $winname(0,1)"
			execute commandstr
		endfor
		commandstr="binvalues(\"ddur1"+sufx+"\",\"Rs"+sufx+"\",\"Tp"+sufx+"\",\"Rs"+sufx+"\",\"Tp"+sufx+"\",\"one x one bin\",15);DoWindow /K $winname(0,1)"
		execute commandstr
		if (doleakcorr==1)
			for (bincounter=1;bincounter<maxdepnum+1;bincounter+=1)
				commandstr="binvalues(\"ddur"+num2str(bincounter)+sufx+"\",\"ileak_h"+num2str(bincounter)+sufx+"\",\"ileak_d"+num2str(bincounter)+sufx+"\",\"iICa_l"+num2str(bincounter)+sufx+"\",\"fICa_l"+num2str(bincounter)+sufx+"\",\"one x one bin\",15);DoWindow /K $winname(0,1)"
				execute commandstr
				commandstr="binvalues(\"ddur"+num2str(bincounter)+sufx+"\",\"pICa_l"+num2str(bincounter)+sufx+"\",\"tpeak"+num2str(bincounter)+sufx+"\",\"Qreal_l"+num2str(bincounter)+sufx+"\",\"Qvirt_l"+num2str(bincounter)+sufx+"\",\"one x one bin\",15);DoWindow /K $winname(0,1)"
				execute commandstr
			endfor
		endif
	endif

	killDataFolder root:MD2temp
	SetDataFolder root:
	print "\rMultiDepol End:",time(), "\r"

End

// ************************************************************************************************************************************
// ** Examine the NaN (=non-sinewave) areas of the Cm wave and save start / end time, calculate start / end time for I wave

Function md2_get_NaN_times(wavnam)

	wave wavnam																//name of wave with Cm values
	NVAR PatchMaster=root:MD2dialog:PatchMaster
	NVAR xcsweepno=root:MD2temp:xcsweepno
	NVAR tcnstb=root:MD2temp:tcnstb
	SVAR PulseV=root:MD2temp:PulseV
	SVAR PNfoldername=root:MD2temp:PNfoldername
	SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
	SVAR cmwavname=root:MD2temp:cmwavname
	SVAR iwavname=root:MD2temp:iwavname
	WAVE /C cm_NaNwav=root:MD2temp:cm_NaNwav								//this wave stores all start- and end-points of the sweep's sine waves					
	WAVE /C cm_plus_NaNwav=root:MD2temp:cm_plus_NaNwav									//this wave stores all start- and end-points of the sweep's sine waves
	WAVE /C I_NaNwav=root:MD2temp:I_NaNwav									//this wave stores all start- and end-points of the sweep's sine waves
	WAVE nanpot=root:MD2temp:nanpot
	string olddatafolder, stimwavename

	nanpot = nan
	stimwavename=removeending(nameofwave(wavnam),"_Cm")+"_stim"
	
	WAVE stimwave = $CurrAnaFolder+":PoN:"+PNfoldername+":"+possiblyquotename(stimwavename)
	variable startp, endp=-1, npts, index, sinecount, depcount, endofwav=0, baddep=0, i, endpi, startpi

	npts = numpnts(wavnam)														//total number of points in Cm wave
	
	cm_NaNwav=NaN
	cm_plus_NaNwav=NaN
	I_NaNwav=NaN
	I_NaNwav[0] = 0																//will be set to 1 if 0ms depol is detected
	
	if(numtype(wavnam[0])==2||(Patchmaster))													//pulse on MAC exports NAN on position [0], whereas PC version exports ~e-37
		PulseV = "MAC"
		for (sinecount=1 ; endofwav!=1 ; sinecount+=1)								//loop and count number of depols until end of sweep
			for (index=(endp+1) ; numtype(wavnam[index]) == 2 ; index+=1)			//loop until end of NaN segment (newer versions of Pulse export NaN for 1st points)
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(wavnam), "does not contain any sine wave"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this means that the wave stops within the depol!!! no calculation possible
					endofwav=1
					baddep=1
					break
				endif
			endfor

			startp = index														//startp = 1st non-NaN-point of current depol
	
			for (index=startp ; (numtype(wavnam[index]) != 2 && endofwav!=1) ; index+=1)	//loop until beginning of next NaN segment
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(wavnam), "does not contain any depolarization"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this is the normal end of the wave
					endofwav=1
					index+=1
					break
				endif
			endfor
			endp = (index-1)														//last point before next NaN segment begins or endpoint
		
//			i = startp * (numpnts(stimwave)+1+(PatchMaster*(-1)))/numpnts(wavnam)  // changed by Jakob to allow different ratios of IWave / CmWave frequency
			i = startp * (numpnts(stimwave))/numpnts(wavnam)  // changed by Jakob to allow different ratios of IWave / CmWave frequency
			do																	// move left while there is still no const segment to the left
				if (!((stimwave[i] != stimwave[i-1]) || (stimwave[i] != stimwave[i-2])))		// Added by Jakob in case no cycle was skipped
					break
				endif
				i-=1																// (needed because Pulse skips x cycles for Cm as defined in LockIn properties)
			while ((stimwave[i] != stimwave[i-1]) || (stimwave[i] != stimwave[i-2]))
			startpi = i							
//			If (stimwave[i] != stimwave[i+1])		// changed by Aaron in case no cycle was skipped (e.g. Patchmaster)
//				startpi = i
//			Else
//				startpi = i+1
//			Endif

			i = endp * (numpnts(stimwave))/numpnts(wavnam)  // changed by Jakob to allow different ratios of IWave / CmWave frequency
			do
				if (!((stimwave[i] != stimwave[i+1]) || (stimwave[i] != stimwave[i+2])))		// Added by Jakob in case no cycle was skipped
					break
				endif																	// move right while there is still no const segment to the right
				i+=1															// (needed because Pulse skips x cycles for Cm as defined in LockIn properties)
			while ((stimwave[i] != stimwave[i+1]) || (stimwave[i] != stimwave[i+2]))
			endpi = i
//			If (stimwave[i] != stimwave[i-1])		// changed by Aaron in case no cycle was skipped (e.g. Patchmaster)
//				endpi = i
//			Else
//				endpi = i-1
//			Endif

			
			depcount = (sinecount-1-baddep)
			cm_NaNwav[(sinecount)] = cmplx(pnt2x(wavnam, startp), pnt2x(wavnam, endp))		//start and end-x of each sine-segment  !! x !!
			cm_plus_NaNwav[(sinecount)] = cmplx(pnt2x(wavnam, startp-1), pnt2x(wavnam, endp+1))	//last x (of depol+cnst) before and first x (of depol+cnst) after sine-segment  !! x !!
//			If (Patchmaster)	// Added by Aaron to accommodate shifted (half-) point in lock-in traces
//				cm_plus_NaNwav[(sinecount)] = cmplx(pnt2x(wavnam, startp), pnt2x(wavnam, endp+1))	//last x (of depol+cnst) before and first x (of depol+cnst) after sine-segment  !! x !!
//			Endif
			I_NaNwav[(sinecount)] = cmplx(pnt2x(stimwave, startpi), pnt2x(stimwave, endpi))		// start- and end-x of each sine for the I wave
			nanpot[sinecount] = 1e3 * stimwave(pnt2x(stimwave, endpi) + tcnstb)				// depol potential after sinewave

			if ((real(cm_plus_NaNwav[2]) - real(I_NaNwav[2]) >= 0.0001)&&!(Patchmaster))   //only true, if depol = 0 ms, must be a bug in HEKA/Pulse
				I_NaNwav[0] = 1
				nanpot[sinecount-1] = NAN
			endif
		endfor
	else
		PulseV = "PC"
		for (sinecount=1 ; endofwav!=1 ; sinecount+=1)								//loop and count number of depols until end of sweep
			for (index=(endp+1) ;wavnam[index]<(1e-20); index+=1)					//loop until end of NaN segment (newer versions of Pulse export NaN for 1st points)
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(wavnam), "does not contain any sine wave"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this means that the wave stops within the depol!!! no calculation possible
					endofwav=1
					baddep=1
					break
				endif
			endfor
			startp = index														//startp = 1st non-NaN-point of current depol
		
			if (!startp)
				startp=1
			endif
		
			for (index=startp ; (wavnam[index]>(1e-20) && endofwav!=1) ; index+=1)		//loop until beginning of next NaN segment
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(wavnam), "does not contain any depolarization"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this is the normal end of the wave
					endofwav=1
					index+=1
					break
				endif
			endfor
			endp = (index-1)														//last point before next NaN segment begins or endpoint

			i = startp * (numpnts(stimwave)+1+(PatchMaster*(-1)))/numpnts(wavnam)  // changed by Jakob to allow different ratios of IWave / CmWave frequency
			do
				i-=1
			while ((stimwave[i] != stimwave[i-1]) || (stimwave[i] != stimwave[i-2]))
			startpi = i

			i = endp * (numpnts(stimwave)+1+(PatchMaster*(-1)))/numpnts(wavnam)  // changed by Jakob to allow different ratios of IWave / CmWave frequency
			do
				i+=1
			while ((stimwave[i] != stimwave[i+1]) || (stimwave[i] != stimwave[i+2]))
			endpi = i
			
			depcount = (sinecount-1-baddep)
			cm_NaNwav[(sinecount)] = cmplx(pnt2x(wavnam, startp), pnt2x(wavnam, endp))		//start and end-x of each sine-segment (scaling of cm wave !!) x !!
			cm_plus_NaNwav[(sinecount)] = cmplx(pnt2x(wavnam, startp-1), pnt2x(wavnam, endp+1))	//last x (of depol+cnst) before and first x (of depol+cnst) after sine-segment (scaling of cmwave !!) x !!
			I_NaNwav[(sinecount)] = cmplx(pnt2x(stimwave, startpi), pnt2x(stimwave, endpi))	
			nanpot[sinecount] = 1e3 * stimwave(pnt2x(stimwave, endpi) + tcnstb)
			if (real(cm_plus_NaNwav[2]) - real(I_NaNwav[2]) >= 0.0001)   //only true, if depol = 0 ms, must be a bug in HEKA/Pulse
				I_NaNwav[0] = 1
				nanpot[sinecount-1] = NAN
			endif
		endfor
	endif

	cm_NaNwav[0] = (depcount)
	cm_plus_NaNwav[0] = (depcount)
end

// ************************************************************************************************************************************
// ** Returns a numerical value taken from the wavenote, which needs to be written there as  instr*(tab)Number

function md2_getfromnote(inwave,instr)

wave inwave
string instr
variable i, outvar
string splitstr

for (i=0;i<itemsinlist(note(inwave));i+=1)
	splitstr= stringfromlist(i,note(inwave))
	if (stringmatch(splitstr,"\r"+instr+"*"))
		splitstring /E="\\t([-/+]*[\\d.]+[e]*[-\+]*[\\d]*)" stringfromlist(i,note(inwave)), splitstr
		return str2num(splitstr)
	endif
endfor
return NaN

end

// ************************************************************************************************************************************
// ** Returns a string from the wavenote, which needs to be written as instr*:(tab)String

function /S md2_getstringfromnote(inwave,instr)

wave inwave
string instr
variable i, outvar
string trashstr, splitstr

for (i=0;i<itemsinlist(note(inwave));i+=1)
	splitstr= stringfromlist(i,note(inwave))
	if (stringmatch(splitstr,"\r"+instr+"*"))
		splitstring /E=":\\t+(.+)" stringfromlist(i,note(inwave)), splitstr
		return splitstr
	endif
endfor
return ""

end

// ************************************************************************************************************************************
// ** Returns a time value taken from the wavenote, which needs to be written there as  instr*(tab)hh:mm:ss.splitsecs
// ** Return value is in seconds

function md2_gettimefromnote(inwave,instr)

wave inwave
string instr
variable i, outvar
string splitstr, hours, minutes, seconds

for (i=0;i<itemsinlist(note(inwave));i+=1)
	splitstr= stringfromlist(i,note(inwave))
	if (stringmatch(splitstr,"\r"+instr+"*"))
		splitstring /E="\\t([\\d.:]+)" stringfromlist(i,note(inwave)), splitstr
		splitstring /E="([0-9]+):([0-9]+):([0-9.]+)" splitstr, hours, minutes, seconds
		return (3600*str2num(hours))+60*str2num(minutes)+str2num(seconds)
	endif
endfor
return NaN

end

// ************************************************************************************************************************************
// ** find the time of the first and last recording

function md2_compare_times()

	NVAR indx=root:MD2temp:indx, actualtime=root:MD2temp:actualtime, firsttime=root:MD2temp:firsttime, lasttime=root:MD2temp:lasttime
	SVAR actualdate=root:MD2temp:actualdate, firstdate=root:MD2temp:firstdate, lastdate=root:MD2temp:lastdate	
		
	if (indx==0)
		firsttime = actualtime
		lasttime = actualtime
		firstdate = actualdate
		lastdate = actualdate
	endif 
	if  (actualtime < firsttime)
		firsttime = actualtime
		firstdate = actualdate
	endif
	if (actualtime > lasttime)
		lasttime = actualtime
		lastdate = actualdate
	endif
end	

// ************************************************************************************************************************************
// ** Get capacitance change (dCms, dCml)

Function  /C md2_get_deltaCm(wavnam, depcount)

	wave wavnam															// names of waves with NaN- and Cm-values
	variable depcount				
	WAVE cm_NaNwav=root:MD2temp:cm_NaNwav
	NVAR maxavgtb=root:MD2temp:maxavgtb, maxavgta=root:MD2temp:maxavgta, tskp=root:MD2temp:tskp
	NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta
	NVAR pdCm_smoothfactor=root:MD2temp:pdCm_smoothfactor					//constant used for smoothing of Cm-wave,  peak-calculation
	NVAR screen=root:MD2dialog:screen
	NVAR DoSlopeCor=root:MD2dialog:DoSlopeCor
	SVAR cmwavname=root:MD2temp:cmwavname
	variable stxwb, endxwb, stxwa, endxwa										//start and endpoints of sine wave
	variable stxcb, endxcb, stxca, endxca										//start and endpoints for calculation
	variable cmsb, cmsa, cmla, cmlb, skptb										// mean Cms and Cml before and after depol, skip time for first sine segment
	variable stxcblim, endxcalim, tlim
	
	if (depcount==1) 															//don't skip at the very beginning of depol
		skptb=0														
	else 
		skptb=tskp
	endif
	
	stxwb = real(cm_NaNwav[depcount])										//starting point of sine wave before depol (converted to x)
	endxwb = imag(cm_NaNwav[depcount])										//ending point of sine wave before depol (converted to x)
	stxwa = real(cm_NaNwav[depcount+1])										//starting point of sine wave after depol (converted to x)
	endxwa = imag(cm_NaNwav[depcount+1])									//ending point of sine wave after depol (converted to x)
			
	stxcb=stxwb+skptb; endxcb=endxwb; stxca=stxwa-tcnsta+tskp; endxca=endxwa	// stxca=stxwa-tcnsta+tskp --> averaging really starts at end of depol,
																				// not at end of depol+const segment!  (WHY?)
	if ((stxcb>=endxcb) || (stxca>=endxca))
		print "ERROR: time to skip is too big! (probably bigger than interdepol interval)"
		return NaN
	endif
	
	if ((endxcb-stxcb)>maxavgtb)												//limit averaging before depol to maxavgtb
		stxcb=(endxcb-maxavgtb)
	endif
	
	if ((endxca-stxca)>maxavgta)												//limit averaging after depol to maxavgta
		endxca=(stxca+maxavgta)
	endif
	
	cmlb = mean(wavnam, stxcb, endxcb)										// The Cml value before depolarization
	cmla = mean(wavnam, stxca, endxca)										// The Cml value after depolarization

	if ((endxca-stxca) <= (endxcb-stxcb))
		tlim = (endxca-stxca)
	else
		tlim = (endxcb-stxcb)
	endif
	
	stxcblim = endxcb-tlim
	endxcalim = stxca+tlim
	
	cmsb = mean(wavnam, stxcblim, endxcb)									// The Cms value before depolarization
	cmsa = mean(wavnam, stxca, endxcalim)									// The Cms value after depolarization
	
	ControlInfo /W=MD2UserDialog cMainDisp
	if (V_Value&&(!DoSlopeCor))
		ControlInfo /W=MD2UserDialog cdisp_Cm
		if (V_value)															//display Cm values, cmb and cma if selected
			NVAR wtim_Cm = root:MD2dialog:wtim_Cm
			make /o /n=2 clbef, claft, csbef, csaft								// display waves for mean Cms, Cml
			clbef[0,1] = cmlb; setscale /i x, stxcb, endxcb, clbef
			claft[0,1] = cmla; setscale /i x, stxca, endxca, claft
			csbef[0,1] = cmsb; setscale /i x, stxcblim, endxcb, csbef
			csaft[0,1] = cmsa; setscale /i x, stxca, endxcalim, csaft
			display /W=(20,40,screen-20,240) wavnam as cmwavname
			SetAxis left cmlb-(2e-14),cmla+(2e-14)
			dowindow /C depol_graph
			label /W=depol_graph bottom "\\u#2time (sec)"
			label /W=depol_graph left "\\u#2capacitance (pF)"
			appendtograph /c=(0,0,1) clbef, claft
			modifygraph /W=depol_graph lsize (clbef) = 2
			modifygraph /W=depol_graph lsize (claft) = 2
			appendtograph /c=(1,16019,65535) csbef, csaft
			modifygraph /W=depol_graph lsize (csbef) = 2, lsize (csaft) = 2, lstyle(csbef)=3, lstyle(csaft)=3
			
			display /W=(20,270,screen-20,470) wavnam as cmwavname					// display Cm waves at a lower zoom
			SetAxis left cmlb-(8e-14),cmla+(8e-14)
			dowindow /C depol_graph_2
			label /W=depol_graph_2 bottom "\\u#2time (sec)"
			label /W=depol_graph_2 left "\\u#2capacitance (pF)"
			appendtograph /c=(0,0,1) clbef, claft
			modifygraph /W=depol_graph_2 lsize (clbef) = 2
			modifygraph /W=depol_graph_2 lsize (claft) = 2
			appendtograph /c=(1,16019,65535) csbef, csaft
			modifygraph /W=depol_graph_2 lsize (csbef) = 2, lsize (csaft) = 2, lstyle(csbef)=3, lstyle(csaft)=3
			
			doupdate
	
			sleep /s wtim_Cm
			dowindow /k depol_graph												// kill the graph
			dowindow /k depol_graph_2
					
			killwaves /Z claft, clbef, csaft, csbef
		endif
	endif
	return cmplx(((cmsa - cmsb)*1e15), ((cmla - cmlb)*1e15))							// dCml for the long averaging period and dCms for the short averaging period are returned in fF
end

// ************************************************************************************************************************************
// ** Get capacitance change (dCms, dCml) from Cm wave corrected for slope by fitting and subtracting a line to the initial segment

Function  /C md2_get_deltaCm_cor(wavnam, depcount)

	wave wavnam															// names of waves with NaN- and Cm-values
	variable depcount				
	WAVE cm_NaNwav=root:MD2temp:cm_NaNwav
	NVAR maxavgtb=root:MD2temp:maxavgtb, maxavgta=root:MD2temp:maxavgta, tskp=root:MD2temp:tskp
	NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta
	NVAR pdCm_smoothfactor=root:MD2temp:pdCm_smoothfactor					//constant used for smoothing of Cm-wave,  peak-calculation
	NVAR screen=root:MD2dialog:screen
	NVAR DoSlopeCor=root:MD2dialog:DoSlopeCor
	SVAR cmwavname=root:MD2temp:cmwavname
	variable stxwb, endxwb, stxwa, endxwa										//start and endpoints of sine wave
	variable stxcb, endxcb, stxca, endxca										//start and endpoints for calculation
	variable cmsb, cmsa, cmla, cmlb, skptb										// mean Cms and Cml before and after depol, skip time for first sine segment
	variable cmsb_c, cmsa_c, cmla_c, cmlb_c									// mean Cms and Cml before and after depol, corrected for slope
	variable stxcblim, endxcalim, tlim
	
	if (depcount==1) 															//don't skip at the very beginning of depol
		skptb=0														
	else 
		skptb=tskp
	endif
	
	stxwb = real(cm_NaNwav[depcount])										//starting point of sine wave before depol (converted to x)
	endxwb = imag(cm_NaNwav[depcount])										//ending point of sine wave before depol (converted to x)
	stxwa = real(cm_NaNwav[depcount+1])										//starting point of sine wave after depol (converted to x)
	endxwa = imag(cm_NaNwav[depcount+1])									//ending point of sine wave after depol (converted to x)
			
	stxcb=stxwb+skptb; endxcb=endxwb; stxca=stxwa-tcnsta+tskp; endxca=endxwa	// stxca=stxwa-tcnsta+tskp --> averaging really starts at end of depol,
																				// not at end of depol+const segment!  (WHY?)
	if ((stxcb>=endxcb) || (stxca>=endxca))
		print "ERROR: time to skip is too big! (probably bigger than interdepol interval)"
		return NaN
	endif
	
	if ((endxcb-stxcb)>maxavgtb)												//limit averaging before depol to maxavgtb
		stxcb=(endxcb-maxavgtb)
	endif
	
	if ((endxca-stxca)>maxavgta)												//limit averaging after depol to maxavgta
		endxca=(stxca+maxavgta)
	endif
	
	duplicate /O wavnam $nameofwave(wavnam)+"_cor"
	wave corwave=$nameofwave(wavnam)+"_cor"
	CurveFit /Q line corwave(stxcb, endxcb) /D
	duplicate /O $"fit_"+nameofwave(corwave) $"root:MD2temp:fitwaveb"
	wave fitwaveb=$"root:MD2temp:fitwaveb"
	wave W_coef=W_coef
	variable V_coef=W_coef[1]
	CurveFit /Q line corwave(stxca, inf) /D
	wave fitwavea=$"fit_"+nameofwave(corwave)
	V_coef=(V_coef+W_coef[1])/2
	corwave-=V_coef*x
		

	cmlb = mean(wavnam, stxcb, endxcb)										// The Cml value before depolarization
	cmla = mean(wavnam, stxca, endxca)										// The Cml value after depolarization
		
	cmlb_c = mean(corwave, stxcb, endxcb)									// The Cml value before depolarization, corrected for slope by linefit
	cmla_c = mean(corwave, stxca, endxca)									// The Cml value after depolarization, corrected for slope by linefit

	if ((endxca-stxca) <= (endxcb-stxcb))
		tlim = (endxca-stxca)
	else
		tlim = (endxcb-stxcb)
	endif
	
	stxcblim = endxcb-tlim
	endxcalim = stxca+tlim
	
	cmsb = mean(wavnam, stxcb, endxcb)										// The Cml value before depolarization
	cmsa = mean(wavnam, stxca, endxca)										// The Cml value after depolarization

	cmsb_c = mean(corwave, stxcb, endxcb)									// The Cml value before depolarization, corrected for slope by linefit
	cmsa_c = mean(corwave, stxca, endxca)									// The Cml value after depolarization, corrected for slope by linefit

	ControlInfo /W=MD2UserDialog cMainDisp
	if (V_Value)
		ControlInfo /W=MD2UserDialog cdisp_Cm
		if (V_value)															//display Cm values, cmb and cma if selected
			NVAR wtim_Cm = root:MD2dialog:wtim_Cm
			make /o /n=2 clbef, claft, csbef, csaft								// display waves for mean Cms, Cml
			make /o /n=2 clbef_c, claft_c, csbef_c, csaft_c						// display waves for mean slope corrected Cms, Cml
			clbef[0,1] = cmlb; setscale /i x, stxcb, endxcb, clbef
			claft[0,1] = cmla; setscale /i x, stxca, endxca, claft
			csbef[0,1] = cmsb; setscale /i x, stxcblim, endxcb, csbef
			csaft[0,1] = cmsa; setscale /i x, stxca, endxcalim, csaft
			clbef_c[0,1] = cmlb_c; setscale /i x, stxcb, endxcb, clbef_c
			claft_c[0,1] = cmla_c; setscale /i x, stxca, endxca, claft_c
			csbef_c[0,1] = cmsb_c; setscale /i x, stxcblim, endxcb, csbef_c
			csaft_c[0,1] = cmsa_c; setscale /i x, stxca, endxcalim, csaft_c
			display /W=(20,40,screen-20,240) wavnam as cmwavname
			AppendToGraph /c=(16384,65280,16384) corwave					// Append slope corrected wave in light green
			AppendToGraph /c=(65280,32640,32640) fitwaveb					// Append linefit in light red
			AppendToGraph /c=(65280,32640,32640) fitwavea					// Append linefit in light red	
			SetAxis left min(cmlb,cmlb_c)-(2e-14),max(cmla,cmla_c)+(2e-14)
			dowindow /C depol_graph
			modifygraph /W=depol_graph lsize ($nameofwave(fitwaveb)) = 2
			modifygraph /W=depol_graph lsize ($nameofwave(fitwavea)) = 2
			label /W=depol_graph bottom "\\u#2time (sec)"
			label /W=depol_graph left "\\u#2capacitance (pF)"
			appendtograph /c=(0,0,1) clbef, claft
			appendtograph /c=(0,0,1) clbef_c, claft_c
			modifygraph /W=depol_graph lsize (clbef) = 2
			modifygraph /W=depol_graph lsize (claft) = 2
			modifygraph /W=depol_graph lsize (clbef_c) = 2
			modifygraph /W=depol_graph lsize (claft_c) = 2
			appendtograph /c=(1,16019,65535) csbef, csaft
			appendtograph /c=(1,65535,16019) csbef_c, csaft_c
			modifygraph /W=depol_graph lsize (csbef) = 2, lsize (csaft) = 2, lstyle(csbef)=3, lstyle(csaft)=3
			modifygraph /W=depol_graph lsize (csbef_c) = 2, lsize (csaft_c) = 2, lstyle(csbef_c)=3, lstyle(csaft_c)=3
			
			display /W=(20,270,screen-20,470) wavnam as cmwavname			// display Cm waves at a lower zoom
			AppendToGraph /c=(16384,65280,16384) corwave					// Append slope corrected wave in light green
			AppendToGraph /c=(65280,32640,32640) fitwaveb						// Append linefit in light red
			AppendToGraph /c=(65280,32640,32640) fitwavea						// Append linefit in light red
			SetAxis left min(cmlb,cmlb_c)-(8e-14),max(cmla,cmla_c)+(8e-14)
			dowindow /C depol_graph_2
			modifygraph /W=depol_graph_2 lsize ($nameofwave(fitwaveb)) = 2
			modifygraph /W=depol_graph_2 lsize ($nameofwave(fitwavea)) = 2
			label /W=depol_graph_2 bottom "\\u#2time (sec)"
			label /W=depol_graph_2 left "\\u#2capacitance (pF)"
			appendtograph /c=(0,0,1) clbef, claft
			modifygraph /W=depol_graph_2 lsize (clbef) = 2
			modifygraph /W=depol_graph_2 lsize (claft) = 2
			appendtograph /c=(1,16019,65535) csbef, csaft
			modifygraph /W=depol_graph_2 lsize (csbef) = 2, lsize (csaft) = 2, lstyle(csbef)=3, lstyle(csaft)=3
			
			doupdate
	
			sleep /s wtim_Cm
			dowindow /k depol_graph												// kill the graph
			dowindow /k depol_graph_2
					
			killwaves /Z claft, clbef, csaft, csbef
		endif
	endif
	return cmplx(((cmsa - cmsb)*1e15), ((cmla - cmlb)*1e15))							// dCml for the long averaging period and dCms for the short averaging period are returned in fF
end

// ************************************************************************************************************************************
// ** Get data of current traces (iICa, fICa, pICa, tpeak) as well as leak corrected versions, when appropriate

Function md2_get_ICa(iwave, depcount)

	wave  iwave
	variable depcount
	
	NVAR doleakcorr=root:MD2dialog:doleakcorr	
	NVAR tcnstb=root:MD2temp:tcnstb, 	tcnsta=root:MD2temp:tcnsta
	NVAR screen=root:MD2dialog:screen
	NVAR ZeroSubtract=root:MD2dialog:ZeroSubtract
	WAVE cm_plus_NaNwav=root:MD2temp:cm_plus_NaNwav
	NVAR iICa_smoothfactor=root:MD2temp:iICa_smoothfactor
	NVAR ICa_i=root:MD2temp:ICa_i, ICa_f=root:MD2temp:ICa_f, Ipeak=root:MD2temp:Ipeak, t_peak=root:MD2temp:t_peak, twadjust=root:MD2temp:twadjust
	if (doleakcorr==1)
		NVAR ICa_i_l=root:MD2temp:ICa_i_l, ICa_f_l=root:MD2temp:ICa_f_l, Ipeak_l=root:MD2temp:Ipeak_l
	endif
	NVAR iI_left=root:MD2temp:iI_left, iI_right=root:MD2temp:iI_right						//sets timewindow for measurement of initial ICa relativ (+) to beginning of depol [sec]
	NVAR fI_left=root:MD2temp:fI_left, fI_right=root:MD2temp:fI_right						//sets timewindow for measurement of final ICa relativ (-) to end of depol [sec]
	NVAR hl_left=root:MD2temp:hl_left, hl_right=root:MD2temp:hl_right					//sets timewindow for measurement of leak current (leaktype=1) during constant at holding potential relativ (-) to beginning of depol [sec]

	twadjust=0
	md2_Set_Analysis_Variables("Ca_tw")												// reset timewindow variables

	variable stx, endx, a, b, ZeroCurrent
	
	newdatafolder /o/s root:MD2temp:ICa
	
	duplicate /O iwave iwave_sm
	smooth iICa_smoothfactor, iwave_sm										//smoothed iwave for iICa calculation
	
	stx = imag(cm_plus_NaNwav[depcount]) + tcnstb									//first x after sinewave and after constant = beginning of depol
	endx = real(cm_plus_NaNwav[depcount+1]) - tcnsta									//last x of depol

	if (ZeroSubtract)
		ZeroCurrent=mean(iwave,stx-hl_left, stx-hl_right)
	else
		ZeroCurrent=0
	endif

	if (iI_right > (endx-stx))													// adjust time window if longer than depol --> clip to end of depol
		iI_right = (endx-stx)
		twadjust=1
	endif
	if (iI_left > (endx-stx))														// adjust timewindow if start is after end of depol --> set to middle of depol
		iI_left = (endx-stx)/2
	endif
	
	wavestats /q/r = (stx,endx) iwave											// start at max of iwave (to avoid finding a peak in the onset transient?)
	wavestats /q /r = (V_maxloc,endx-0.001) iwave_sm							//changed to find correct peak (not in tail)						
	Ipeak = (V_min-ZeroCurrent) * 1e12														//peak current during depol in pA
	t_peak = V_minloc - stx													//time of peak relative to beginning of depol


	ICa_i = 1e12 * (mean(iwave_sm, stx+iI_left,stx+iI_right)-ZeroCurrent) 						//peak Ca current at beginning of depol; in pA     // changed to represent initial current TM
	ICa_f = 1e12 * (mean(iwave_sm, endx-fI_left, endx-fI_right)-ZeroCurrent)						//Ca current at end of depol, given in pA

	if (twadjust==1)															// If the time window was too small for the initial current, it does not make sense to
		ICa_f = ICa_i															// look at a final current...
	endif		

	if (doleakcorr == 1)
		NVAR leaktype=root:MD2dialog:leaktype		
		switch(leaktype)	
			case 1:				// "linear leak"
				SVAR sufx=root:MD2temp:sufx, currAnaFolder=root:MD2temp:currAnaFolder
				WAVE V_hold = $currAnaFolder+":hpot"+sufx
				NVAR tcnstb=root:MD2temp:tcnstb
				NVAR h_ileak=root:MD2temp:h_ileak, d_ileak=root:MD2temp:d_ileak, ICa_i_l=root:MD2temp:ICa_i_l, ICa_f_l=root:MD2temp:ICa_f_l, Ipeak_l=root:MD2temp:Ipeak_l
				NVAR V_rev=root:MD2temp:V_rev, deppot=root:MD2temp:deppot, indx=root:MD2temp:indx

				duplicate /O iwave, iwave_l

				if (waveexists($"root:MD2temp:"+nameofwave(iwave)+"_leak"))						// If the wave is already p/n corrected, undo the p/n.
					wave leakwave=$"root:MD2temp:"+nameofwave(iwave)+"_leak"
					iwave_l+=leakwave
				endif
				
				duplicate /O iwave_l iwave_l_sm
				smooth iICa_smoothfactor, iwave_l_sm

				if (tcnstb == 0)
					h_ileak = NaN
				else	
					h_ileak = mean(iwave_l,stx-hl_left, stx-hl_right) * 1e12  						//leak current during constant (holding potential) preceeding depol [pA]
				endif
				a =  h_ileak / (V_hold[indx]-V_rev); b = -(a*V_rev)							//calculates the linear leak current (y=ax+b) line
				d_ileak= (a*deppot+b)													//"linear leak" current at depolarizing potential [pA]
			
				wavestats /q/r = (stx,endx) iwave_l											// start at max of iwave (to avoid finding a peak in the onset transient?)
				wavestats /q /r = (V_maxloc,endx-0.001) iwave_l_sm							//changed to find correct peak (not in tail)	
				
				ICa_i_l = (mean(iwave_l_sm, stx+iI_left,stx+iI_right)*1e12) - d_ileak					//initial ICa, 'linear leak'-compensated
				ICa_f_l = (mean(iwave_l_sm, endx-fI_left, endx-fI_right)*1e12) - d_ileak				//final ICa, 'linear leak'-compensated
				Ipeak_l = (V_min*1e12) - d_ileak												//peak ICa, 'linear leak'-compensated

				break
			case 2:				// "separate p/N pulse"
				NVAR h_ileak=root:MD2temp:h_ileak, d_ileak=root:MD2temp:d_ileak, ICa_i_l=root:MD2temp:ICa_i_l, ICa_f_l=root:MD2temp:ICa_f_l, Ipeak_l=root:MD2temp:Ipeak_l
				NVAR V_rev=root:MD2temp:V_rev, deppot=root:MD2temp:deppot, indx=root:MD2temp:indx
				SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
				SVAR PNfoldername = root:MD2temp:PNfoldername
				NVAR xcsweepno = root:MD2temp:xcsweepno
				NVAR Vlj = root:MD2dialog:Vlj
				SVAR sufx=root:MD2temp:sufx, currAnaFolder=root:MD2temp:currAnaFolder
				WAVE V_hold = $currAnaFolder+":hpot"+sufx
				WAVE Cm_plus_NaNwav=root:MD2temp:Cm_plus_NaNwav
				variable scalefactor
				variable leakoffset
//				abort "Not supported yet!"
				
				string leakname=md2_BuildLeakWave(iwave)
				wave leakwave=$CurrAnaFolder+":PoN:"+leakname
				wave leakstim=$CurrAnaFolder+":PoN:"+leakname+"_stim"
				if (waveexists($CurrAnaFolder+":PoN:"+leakname+"_leak"))
					wave leakleak=$CurrAnaFolder+":PoN:"+leakname+"_leak"
				endif
				wave iwave_stim=$getwavesdatafolder(iwave,2)+"_stim"
//
//				if (numpnts(leakleak)==numpnts(iwave))		// leakwave is the same size as original wave (why would anyone want this?)
////					scalefactor=(wavemax(iwave_stim,imag(cm_plus_NaNwav[depcount]),real(cm_plus_NaNwav[depcount+1]))-wavemin(iwave_stim,imag(cm_plus_NaNwav[depcount]),real(cm_plus_NaNwav[depcount+1])))/(wavemax(leakstim,imag(cm_plus_NaNwav[depcount]),real(cm_plus_NaNwav[depcount+1]))-wavemin(leakstim,imag(cm_plus_NaNwav[depcount]),real(cm_plus_NaNwav[depcount+1])))
//					scalefactor=0
//					leakoffset=0
//
//				else
				if (numpnts(leakleak)==round((real(cm_plus_NaNwav[depcount+1])-imag(cm_plus_NaNwav[depcount]))/dimdelta(iwave,0)))
					scalefactor=(wavemax(iwave_stim,imag(cm_plus_NaNwav[depcount]),real(cm_plus_NaNwav[depcount+1]))-wavemin(iwave_stim,imag(cm_plus_NaNwav[depcount]),real(cm_plus_NaNwav[depcount+1])))/(wavemax(leakstim)-wavemin(leakstim))
					leakoffset=x2pnt(iwave,imag(cm_plus_NaNwav[depcount]))-1
					duplicate leakleak $CurrAnaFolder+":PoN:"+nameofwave(iwave)+"_leak"
				else
					print "Leak wave "+nameofwave(leakwave)+" does not match!"
					Make /O  $CurrAnaFolder+":PoN:"+nameofwave(iwave)+"_leak"
					wave Leakleak=$CurrAnaFolder+":PoN:"+nameofwave(iwave)+"_leak"
					leakleak=NaN
					scalefactor=NaN
//					break
				endif
				print "leak scale factor:",scalefactor
				variable leak_stx_p = x2pnt(leakwave,imag(cm_plus_NaNwav[depcount]))// + tcnstb)									//first x after sinewave and after constant = beginning of depol
				variable leak_endx_p = x2pnt(leakwave,real(cm_plus_NaNwav[depcount+1]))+1// - tcnsta)									//last x of depol
				variable stx_p=x2pnt(iwave,stx)
				variable endx_p=x2pnt(iwave,endx)
				
				duplicate /O iwave iwave_l
				
				iwave_l[stx_p,endx_p]-=scalefactor*leakleak[p-leakoffset]
				duplicate /O iwave_l, iwave_l_sm
				smooth iICa_smoothfactor, iwave_l_sm										//smoothed iwave for iICa calculation

				NVAR holdleak = $CurrAnaFolder+":PoN:"+PNfoldername+":holdleak"
				NVAR depleak = $CurrAnaFolder+":PoN:"+PNfoldername+":depleak"
				h_ileak = holdleak * 1e12
				d_ileak = depleak * 1e12
				ICa_i_l = 1e12 * mean(iwave_l_sm, stx+iI_left,stx+iI_right) 	
				ICa_f_l = 1e12 * mean(iwave_l_sm, endx-fI_left, endx-fI_right)

				wavestats /q/r = (stx,endx) iwave_l
				wavestats /q /r = (V_maxloc,endx-0.001) iwave_l_sm							//changed to find correct peak (not in tail)						
				Ipeak_l =  V_min * 1e12	
				
				break
		endswitch
 	endif

	ControlInfo /W=MD2UserDialog cMainDisp
	if (V_Value)
		ControlInfo /W=MD2UserDialog cdisp_I
		if (V_Value)
			NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta 
			NVAR wtim_I=root:MD2dialog:wtim_I
			SVAR iwavname=root:MD2temp:iwavname
			variable d_left=0.025+tcnstb, d_right=0.025+tcnsta								//sets relativ timewindow for magnification of current trace during depol [sec]

			duplicate /O iwave pAiwave; pAiwave = iwave * 1e12
			pAiWave-=(ZeroCurrent*1e12)
			duplicate /O pAiwave magnwinwav
			duplicate /O pAiwave depwave
			deletepoints (x2pnt(pAiwave, endx+d_right)+1), numpnts(magnwinwav), magnwinwav	// Trim magnwinwav wave to 0.025 s before and after depol+const segments
			if ((stx-d_left)>0)
				deletepoints 0, x2pnt(pAiwave, stx-d_left), magnwinwav
			elseif ((stx-d_left)<0)
				insertpoints 0, abs(x2pnt(pAiwave, stx-d_left)), magnwinwav
				magnwinwav[0,abs(x2pnt(pAiwave, stx-d_left))]=NaN
			endif				
			setscale /i x, stx-d_left, endx+d_right, magnwinwav
			deletepoints (x2pnt(pAiwave, endx)+1), numpnts(depwave), depwave				// Trim depwave to depol time
			deletepoints 0, x2pnt(pAiwave, stx), depwave
			setscale /i x, stx, endx, depwave
	
			make /n=1 /o Ipeak_x, Ipeak_y, Ipeak_y_l
			make /n=2 /o iniICa, finICa, zeroline, iniICa_l, finICa_l
			iniICa[0,1] = ICa_i; setscale /i x,  stx+iI_left,stx+iI_right, iniICa
			finICa[0,1] = ICa_f; setscale /i x, endx-fI_left, endx-fI_right, finICa
			zeroline[0,1] = 0; setscale /i x, stx-d_left, endx+d_right, zeroline
			Ipeak_x[0] = stx+t_peak; Ipeak_y[0] = Ipeak
	
			if (doleakcorr == 1)
				duplicate /O iwave_l pAiwave_l; pAiwave_l = iwave_l * 1e12
				duplicate /O pAiwave_l depwave1
				make /n=2 /o hleak, dleak
				switch(leaktype)	
					case 1:				// "linear leak"
		 				depwave1-=d_ileak
						break
					case 2:				// "separate p/N pulse"
						depwave1 = iwave_l * 1e12
						break
					case 3:				// "Pulse p/N function"
						depwave1 = iwave_l * 1e12
						break
				endswitch
			
				deletepoints (x2pnt(pAiwave, endx)+1), numpnts(depwave1), depwave1	// Trim leak corrected depwave to depol time
				deletepoints 0, x2pnt(pAiwave, stx), depwave1
				setscale /i x, stx, endx, depwave1

				hleak[0,1] = h_ileak; setscale /i x, stx-hl_left, stx-hl_right, hleak
				dleak[0,1] = d_ileak; setscale /i x, stx-hl_left, stx-hl_right, dleak
				
				Ipeak_y_l[0] = Ipeak_l
				iniICa_l[0,1] = ICa_i_l; setscale /i x,  stx+iI_left,stx+iI_right, iniICa_l
				finICa_l[0,1] = ICa_f_l; setscale /i x, endx-fI_left, endx-fI_right, finICa_l
			endif
	
			
			display /W=(20,40,screen-20,240) pAiwave as iwavname+"   (full scale)"			// entire Iwave in light gray in background
			dowindow /C iwin_f 
			modifygraph /W=iwin_f rgb = (46000,46000,46000)
			appendtograph /Q /W=iwin_f /c=(65000,4500,4500) magnwinwav			// depol current in red
			label /W=iwin_f bottom "\\u#2time (sec)"
			label /W=iwin_f left "\\u#2current (pA)"
			
			display /W=(20,270,screen-20,470) magnwinwav as iwavname + "   (depol no " + num2str(depcount) + ")"		// magnified Iwave in gray
			dowindow /C iwin_d
			modifygraph /W=iwin_d rgb (magnwinwav) = (30000,30000,30000)
			appendtograph /Q /W=iwin_d /c=(65000,4500,4500) depwave				// magnified depol current in red
			if (doleakcorr == 1)
				appendtograph /Q /W=iwin_d /c=(16384,65280,16384) depwave1		// leak corrected depol current in green
				appendtograph /Q /W=iwin_d /c=(16384,65280,16384) dleak			// depol leak in green
				appendtograph /Q /W=iwin_d /c=(10000,40000,0) hleak				// holding leak now in dark green
				appendtograph /Q /W=iwin_d /c=(8000,45000,8000) iniICa_l, finICa_l	// leak corrected Iini, Ifin in darker green
				appendtograph /Q /W=iwin_d /c=(8000,45000,8000) Ipeak_y_l vs Ipeak_x 	// leak corrected Ipeak in darker green
				ModifyGraph mode(Ipeak_y_l)=3,marker(Ipeak_y_l)=18
			endif
			appendtograph /Q /W=iwin_d /c=(0,0,0) iniICa, finICa
			appendtograph /Q /W=iwin_d /c=(0,0,0) zeroline
			ModifyGraph lstyle(zeroline)=1		
			appendtograph /Q /W=iwin_d /c=(0,0,0) Ipeak_y vs Ipeak_x 
			ModifyGraph mode(Ipeak_y)=3,marker(Ipeak_y)=18
	
			label /W=iwin_d bottom "\\u#2time (sec)"
			label /W=iwin_d left "\\u#2current (pA)"
			setAxis /W=iwin_d bottom (stx-d_left),( endx+d_right)
			doupdate
		
			sleep /s wtim_I
			dowindow /k iwin_f
			dowindow /k iwin_d
		
		endif
	endif
//	killdatafolder root:MD2temp:ICa
end

// ************************************************************************************************************************************
// ** Get data of transported charge (Qreal, Qvirt)

Function md2_get_QCa(iwave, depcount)

	wave iwave
	variable depcount
	NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta
	NVAR ICa_i=root:MD2temp:ICa_i, ICa_f=root:MD2temp:ICa_f, depdur=root:MD2temp:depdur, doleakcorr=root:MD2dialog:doleakcorr
	NVAR q_real=root:MD2temp:q_real, q_virt=root:MD2temp:q_virt, ileak_t=root:MD2temp:ileak_t, Qskp_t=root:MD2temp:Qskp_t
	NVAR samplefreq=root:MD2temp:samplefreq
	NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta
	NVAR screen=root:MD2dialog:screen
	NVAR CurrentsOnly=root:MD2dialog:CurrentsOnly
	NVAR ZeroSubtract=root:MD2dialog:ZeroSubtract
	NVAR hl_left=root:MD2temp:hl_left, hl_right=root:MD2temp:hl_right					//sets timewindow for measurement of leak current (leaktype=1) during constant at holding potential relativ (-) to beginning of depol [sec]
	SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
	WAVE cm_plus_NaNwav=root:MD2temp:cm_plus_NaNwav

	variable stx, endx, qstx, qendx, peak, V_FitOptions, ZeroCurrent
	variable d_left=0.025+tcnstb, d_right=0.025+tcnsta							//sets relative timewindow for magnification of current trace during depol [sec]

	newdatafolder /o/s root:MD2temp:QCa

	q_virt = -(ICa_i+ICa_f)/2 * depdur											//Q=I*t; with I = average between ICa at beginning and ICa at end of depol
	
	if (!CurrentsOnly)
		stx = imag(cm_plus_NaNwav[depcount]) + tcnstb								//first x after sinewave and after constant = beginning of depol
		endx = real(cm_plus_NaNwav[depcount+1]) - tcnsta							//last x of depol	1					
	else
		stx = imag(cm_plus_NaNwav[depcount]) + tcnstb
		endx = real(cm_plus_NaNwav[depcount+1]) - tcnsta
	endif
	qstx = stx //+ 0.00075														//will be modified later to match peak
	qendx = endx //+ 0.0015													//calculation of Q stops 1.5ms after end of depol

	if (ZeroSubtract)
		ZeroCurrent=mean(iwave,stx-hl_left, stx-hl_right)
	else
		ZeroCurrent=0
	endif

	if  (doleakcorr == 1)
		NVAR h_ileak=root:MD2temp:h_ileak, d_ileak=root:MD2temp:d_ileak, ICa_i_l=root:MD2temp:ICa_i_l, ICa_f_l=root:MD2temp:ICa_f_l
		NVAR q_virt_l=root:MD2temp:q_virt_l, q_real_l=root:MD2temp:q_real_l, h_ileak=root:MD2temp:h_ileak
		NVAR leaktype=root:MD2dialog:leaktype		
		variable qstx_l, qendx_l
		make /O W_coef

		q_virt_l =  -(ICa_i_l+ICa_f_l)/2 * depdur									//Q=I*t; with I = average between leak-corrected ICa at beginning and ICa at end of depol
				
		qendx_l = qendx
		qstx_l = 	qstx

		switch(leaktype)	
			case 1:				// "linear leak"
			
				duplicate /O iwave iwave_l

				if (waveexists($"root:MD2temp:"+nameofwave(iwave)+"_leak"))						// If the wave is already p/n corrected, undo the p/n.
					wave leakwave=$"root:MD2temp:"+nameofwave(iwave)+"_leak"
					iwave_l+=leakwave
				endif

				duplicate /O iwave_l pAiwave_l, qwave_l, subwave, wavetofit, slowdeact
				pAiwave_l = iwave_l * 1e12 - d_ileak
				qwave_l = iwave_l * 1e12 - d_ileak
				break
			case 2:				// "separate p/N pulse"
				SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
				SVAR PNfoldername = root:MD2temp:PNfoldername
				wave leakwave = $CurrAnaFolder+":PoN:"+nameofwave(iwave)+"_leak"
				
//				duplicate /O iwave pAiwave_l, qwave_l, subwave, wavetofit, slowdeact
//				pAiwave_l = (iwave * 1e12) - (leakwave * 1e12)
//				qwave_l = (iwave * 1e12) - (leakwave * 1e12)
				wave iwave_l=root:MD2temp:ICa:iwave_l
				duplicate /O iwave_l pAiwave_l, qwave_l, subwave, wavetofit, slowdeact
				pAiwave_l *= 1e12
				qwave_l *= 1e12
				break
		endswitch
	
		wavetofit *= 1e12
		FindPeak /B=3 /Q /M=(ICa_f) /N /R=(endx, endx+0.002) wavetofit			// Find max (tail-)current
		if (V_flag == 0)
			peak = V_peakloc
		else 
			WaveStats /Q /R = (endx, endx+0.002) wavetofit
			peak = V_minloc
		endif
		
		deletepoints (x2pnt(pAiwave_l, endx+d_right)+1), numpnts(wavetofit), wavetofit
		deletepoints 0, x2pnt(wavetofit, peak), wavetofit							// trim wavetofit wave to peak of tail current to 25ms+const segment after end of depol
		SetScale/P x 0,samplefreq,"s", wavetofit, slowdeact
		V_FitOptions = 4														// suppress curve fit window
		CurveFit /q dblexp wavetofit
		if ((W_coef[1] >= 0 ) || (W_coef[4] <= 1000))
			CurveFit /q exp wavetofit
		else
		endif
		V_FitOptions = 0
		slowdeact = W_coef[0]+W_coef[1]*exp(-W_coef[2]*x)						// Make slowdeact wave from function fitted to wavetofit. Anything before peak is set to zero.
		InsertPoints 0, x2pnt(pAiwave_l, peak), slowdeact
		deletepoints (x2pnt(pAiwave_l, endx+d_right)+1), numpnts(pAiwave_l), slowdeact		
		slowdeact [0, x2pnt(pAiwave_l, peak)] =0

		subwave= -exp (1/0.00025 * - (x-endx)) + 1								//exp decay of subtracted leakcurrent (0-->1, with tau = 250sec)
		subwave[0,x2pnt(subwave,endx)]=0
		slowdeact *= subwave

		switch(leaktype)														// add the leak, since we are subtracting it again below... (I think)
			case 1:				// "linear leak"
				qwave_l += subwave*d_ileak
				break
			case 2:				// "separate p/N pulse"
				qwave_l += subwave*leakwave
				break
			case 3:				// "Pulse p/N function"
				qwave_l += subwave*leakwave
				break
		endswitch

		qwave_l -= slowdeact													// subtract slow inactivation
		duplicate /O qwave_l qcalwave_l
		integrate qwave_l

		If ( endx <= stx+0.002) 													// changed by Aaron to accommodate pulse < 2ms
			wavestats /Q/R=(stx+Qskp_t,endx) pAiwave_l
			wavestats /Q/R=(V_maxloc, endx) pAiwave_l
		Else
			wavestats /Q/R=(stx+Qskp_t,stx+0.002) pAiwave_l					// changed by Jakob to avoid trouble with small, noisy currents
			wavestats /Q/R=(V_maxloc, stx+0.002) pAiwave_l
		Endif
		
		if (V_min < 0)
			if (V_max >= 0)
				for (qstx_l=stx+0.0005; pAiwave_l(qstx_l)>0; qstx_l+=samplefreq)	//changed to find proper beginning of integral TM
				endfor
			else
				qstx_l = V_maxloc
			endif
//			for (qendx_l=endx; (qcalwave_l(qendx_l)<= 0 && qendx_l < endx+0.0015); qendx_l+=samplefreq)	// only integrate while current is still <0 and max 1.5 ms after end of depol
			for (qendx_l=endx; (!(qcalwave_l(qendx_l)>0 && qcalwave_l(qendx_l+samplefreq)>0) && qendx_l < endx+0.0015); qendx_l+=samplefreq)	// only integrate while current is still <0 and max 1.5 ms after end of depol
			endfor
			qendx_l -= samplefreq
			q_real_l = - (qwave_l(qendx_l) - qwave_l(qstx_l))						//Q_l = integral of leak corrected current; given positive and in pC
		else
			q_real_l = NaN
		endif	
		
		duplicate /O iwave pAiwave, qwave
		pAiwave = (iwave-ZeroCurrent) * 1e12
		qwave = pAiwave - slowdeact
		duplicate /O qwave qcalwave
		integrate qwave															//integration of current-wave
	else
		duplicate /O iwave pAiwave, qwave
		pAiwave = (iwave-ZeroCurrent) * 1e12
		qwave = pAiwave
		duplicate /O qwave qcalwave
		integrate qwave															//integration of current-wave
	endif
	
	If (endx <= stx+0.002)
		wavestats /Q/R=(stx+Qskp_t,endx) pAiwave
		wavestats /Q/R=(V_maxloc, endx) pAiwave
	Else
		wavestats /Q/R=(stx+Qskp_t,stx+0.002) pAiwave					// changed by Jakob to avoid trouble with small, noisy currents
		wavestats /Q/R=(V_maxloc, stx+0.002) pAiwave
	Endif
	
	if (V_min < 0)
		if (V_max >= 0)
			//for (qstx=stx+0.0005; pAiwave(qstx)>0; qstx+=samplefreq)
			for (qstx=stx+Qskp_t; pAiwave(qstx)>0; qstx+=samplefreq)
			endfor
		else
			//qstx = V_maxloc
			qstx=stx+Qskp_t
		endif
		//for (qendx=endx; (qcalwave(qendx)<= 0 && qendx < endx+0.0015); qendx+=samplefreq)
		for (qendx=endx; (!(qcalwave(qendx)>0 && qcalwave(qendx+samplefreq)>0) && qendx < endx+0.0015); qendx+=samplefreq)	// only integrate while current is still <0 and max 1.5 ms after end of depol
		endfor
		qendx -= samplefreq
		q_real = - (qwave(qendx) - qwave(qstx))								//Q = integral of current; given positive and in pC
	else
		q_real = NaN
	endif	
	
	duplicate /O pAiwave expIwav
			
	if  (doleakcorr == 1)
		duplicate /O pAiwave_l expIwav_l
		deletepoints (x2pnt(pAiwave_l, endx+d_right)+1), numpnts(expIwav_l), expIwav_l
		if ((stx-d_left)>0)
			deletepoints 0, x2pnt(pAiwave_l, stx-d_left), expIwav_l
		elseif ((stx-d_left)<0)
			insertpoints 0, abs(x2pnt(pAiwave_l, stx-d_left)), expIwav_l
			expIwav_l[0,abs(x2pnt(pAiwave_l, stx-d_left))]=NaN
		endif
		setscale /p x, stx-d_left, samplefreq, expIwav_l
		slowdeact [0, x2pnt(pAiwave_l, peak)] =NAN
		deletepoints (x2pnt(pAiwave, qendx_l)+1), numpnts(qcalwave_l), qcalwave_l
		deletepoints 0, x2pnt(pAiwave, qstx_l), qcalwave_l
		SetScale/P x qstx_l,samplefreq,"s", qcalwave_l
		make /o /n=1 rQy_l_stx, rQy_l_endx, rQx_l_stx, rQx_l_endx			// For display of start and end points of leak-corrected Qreal
		rQy_l_stx[0] = qcalwave_l(qstx_l); rQx_l_stx[0] = qstx_l
		rQy_l_endx[0] = qcalwave_l(qendx_l); rQx_l_endx[0] = qendx_l
		make /o /n=4 vQ_l, vQy_l											// For display of leak-corrected Qvirt
		vQ_l[0] = ICa_i; vQ_l[1] = ICa_i-d_ileak; vQ_l[2] = ICa_f-d_ileak; vQ_l[3] = ICa_f
		vQy_l[0] = stx; vQy_l[1] = stx; vQy_l[2] = endx; vQy_l[3] = endx
	endif
		
	deletepoints (x2pnt(pAiwave, endx+d_right)+1), numpnts(expIwav), expIwav
	if ((stx-d_left)>0)
		deletepoints 0, x2pnt(pAiwave, stx-d_left), expIwav
	elseif ((stx-d_left)<0)
		insertpoints 0, abs(x2pnt(pAiwave, stx-d_left)), expIwav
		expIwav[0,abs(x2pnt(pAiwave, stx-d_left))]=NaN
	endif
	setscale /p x, stx-d_left, samplefreq, expIwav
	deletepoints (x2pnt(pAiwave, qendx)+1), numpnts(qcalwave), qcalwave
	deletepoints 0, x2pnt(pAiwave, qstx), qcalwave
	SetScale/P x qstx,samplefreq,"s", qcalwave


	ControlInfo /W=MD2UserDialog cMainDisp
	if (V_Value)
		ControlInfo /W=MD2UserDialog cdisp_Q
		if (V_value)
			SVAR iwavname=root:MD2temp:iwavname
			NVAR wtim_Q=root:MD2dialog:wtim_Q, hl_left=root:MD2temp:hl_left, hl_right=root:MD2temp:hl_right
			
			make /o /n=2 hleak													// for display of avg leak at holding potential
			make /o /n=4 vQ, vQy													// For display of non-leak-corrected Qvirt
			make /o /n=1 rQy_stx, rQy_endx, rQx_stx, rQx_endx						// For display of start and end points of non-leak-corrected Qreal
			hleak[0,1] = h_ileak; setscale /i x, stx-hl_left, stx-hl_right, hleak
			vQ[0] = 0; vQ[1] = ICa_i; vQ[2] = ICa_f; vQ[3] = 0
			vQy[0] = stx; vQy[1] = stx; vQy[2] = endx; vQy[3] = endx
			rQy_stx[0] = qcalwave(qstx); rQx_stx[0] = qstx
			rQy_endx[0] = qcalwave(qendx); rQx_endx[0] = qendx
			
			display /W=(20,40,screen-20,240) pAiwave as iwavname+"   (full scale)"			// Display entire iwave in gray
			dowindow /C Qwin_f 
			modifygraph /W=Qwin_f rgb = (46000,46000,46000)
			appendtograph /Q /W=Qwin_f /c=(65000,4500,4500) expIwav				// display current depol in red
			label /W=Qwin_f bottom "\\u#2time (sec)"
			label /W=Qwin_f left "\\u#2current (pA)"
			
			display /W=(20,270,screen-20,470) expIwav as iwavname + "   (depol no " + num2str(depcount) + ")"		// Display magnified iwave in gray
			dowindow /C Qwin_d
			modifygraph /W=Qwin_d rgb (expIwav) = (30000,30000,30000)
			appendtograph /Q /W=Qwin_d /c=(65000,4500,4500) qcalwave				// Display magnified current depol in red
			if  (doleakcorr == 1)
				appendtograph /Q /W=Qwin_d /c=(0,39168,0) qcalwave_l				// Display leak-corrected trace in green
				appendtograph slowdeact											// Display fit for correcting slow deactivation in blue (later)
			endif
			appendtograph /Q /W=Qwin_d /c=(0,0,0) hleak							// Display leak at holding potential in black
			appendtograph /Q /W=Qwin_d /c=(0,0,0) vQ vs vQy						// Display Qvirt in dotted gray (later)
			appendtograph /Q /W=Qwin_d /c=(0,0,0) rQy_stx vs rQx_stx				// Display start point for Qreal as black circle (later)
			appendtograph /Q /W=Qwin_d /c=(0,0,0) rQy_endx vs rQx_endx			// Display end point for Qreal as black circle (later)
			if  (doleakcorr == 1)
				appendtograph /Q /W=Qwin_d /c=(0,0,0) vQ_l vs vQy_l				// Display leak-corrected Qvirt in dotted gray (later)
				appendtograph /Q /W=Qwin_d /c=(0,0,0) rQy_l_stx vs rQx_l_stx		// Display leak-corrected start point for Qreal as black triangle (later)
				appendtograph /Q /W=Qwin_d /c=(0,0,0) rQy_l_endx vs rQx_l_endx	// Display leak-corrected end point for Qreal as black triangle (later)	
			endif
			ModifyGraph lstyle(vQ)=1, rgb(vQ)=(17408,17408,17408), lsize(hleak)=2
			ModifyGraph mode(rQy_stx)=3,marker(rQy_stx)=8
			ModifyGraph mode(rQy_endx)=3,marker(rQy_endx)=8
			if  (doleakcorr == 1)
				ModifyGraph lstyle(vQ_l)=1, rgb(vQ_l)=(17408,17408,17408)
				ModifyGraph 	rgb(slowdeact)=(0,0,65280)
				ModifyGraph mode(rQy_l_stx)=3,marker(rQy_l_stx)=44
				ModifyGraph mode(rQy_l_endx)=3,marker(rQy_l_endx)=44
				ModifyGraph mode(qcalwave_l)=7,useNegRGB(qcalwave_l)=1,usePlusRGB(qcalwave_l)=1, hbFill(qcalwave_l)=2,useNegPat(qcalwave_l)=1, hBarNegFill(qcalwave_l)=2,plusRGB(qcalwave_l)=(32768,65280,32768), negRGB(qcalwave_l)=(32768,65280,32768)
							// Fill leak-corrected Qreal area in light green
			endif
			label /W=Qwin_d bottom "\\u#2time (sec)"
			label /W=Qwin_d left "\\u#2current (pA)"
			setAxis /W=Qwin_d bottom (stx-d_left),( endx+d_right)
			ModifyGraph mode(qcalwave)=7,useNegRGB(qcalwave)=1,usePlusRGB(qcalwave)=1, hbFill(qcalwave)=2,plusRGB(qcalwave)=(65280,43520,32768), negRGB(qcalwave)=(65280,43520,32768)
							// Fill non-leak-corrected Qreal area in light orange
			if  (doleakcorr == 1)
				reordertraces /w=Qwin_d expIwav, {expIwav, qcalwave_l, qcalwave, vQ}
			else
				reordertraces /w=Qwin_d expIwav, {expIwav, qcalwave, vQ}
			endif
			
			ModifyGraph zero(left)=2
			doupdate

			sleep /s wtim_Q
			dowindow /k Qwin_f
			dowindow /k Qwin_d
		
		endif	
	endif

	SVAR iwavname=root:MD2temp:iwavname	
	duplicate /O expIwav  $currAnafolder+":Currents:"+iwavname								// keep the iwave
	duplicate /O qcalwave $currAnafolder+":Currents:"+iwavname+"_Q"							// keep the iwave used for qreal
	if (doleakcorr == 1)
		duplicate /O expIwav_l  $currAnafolder+":Currents:"+iwavname+"_l"
		duplicate /O qcalwave_l $currAnafolder+":Currents:"+iwavname+"_Q_l"
	endif

//	killdatafolder root:MD2temp:QCa
end

// ************************************************************************************************************************************
// ** Get postsynaptic response integral

Function md2_get_QPost(iwave, depcount)

	wave iwave
	variable depcount

	NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta
	NVAR ICa_i=root:MD2temp:ICa_i, ICa_f=root:MD2temp:ICa_f, depdur=root:MD2temp:depdur, doleakcorr=root:MD2dialog:doleakcorr
	NVAR q_real=root:MD2temp:q_real, q_virt=root:MD2temp:q_virt, ileak_t=root:MD2temp:ileak_t, Qskp_t=root:MD2temp:Qskp_t
	NVAR q_post=root:MD2temp:q_post
	NVAR samplefreq=root:MD2temp:samplefreq
	NVAR tcnstb=root:MD2temp:tcnstb, tcnsta=root:MD2temp:tcnsta
	NVAR screen=root:MD2dialog:screen
	NVAR CurrentsOnly=root:MD2dialog:CurrentsOnly
	NVAR ZeroSubtract=root:MD2dialog:ZeroSubtract
	NVAR hl_left=root:MD2temp:hl_left, hl_right=root:MD2temp:hl_right					//sets timewindow for measurement of leak current (leaktype=1) during constant at holding potential relativ (-) to beginning of depol [sec]
	SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
	WAVE cm_plus_NaNwav=root:MD2temp:cm_plus_NaNwav

	variable stx, endx, qstx, qendx, peak, V_FitOptions, ZeroCurrent
	variable d_left=0.025+tcnstb, d_right=0.025+tcnsta							//sets relative timewindow for magnification of current trace during depol [sec]

	if (waveexists($getwavesdatafolder(iwave,2)+"_2"))
		wave postwave=$getwavesdatafolder(iwave,2)+"_2"
	else
		return -1
	endif
	
	newdatafolder /o/s root:MD2temp:QPost

	if (!CurrentsOnly)
		stx = imag(cm_plus_NaNwav[depcount]) + tcnstb								//first x after sinewave and after constant = beginning of depol
		endx = real(cm_plus_NaNwav[depcount+1]) - tcnsta	+0.02						//last x of depol	1				//TEMP Integrate for 20 ms after end of depol	
	else
		stx = imag(cm_plus_NaNwav[depcount]) + tcnstb
		endx = real(cm_plus_NaNwav[depcount+1]) - tcnsta + 0.02				//TEMP Integrate for 20 ms after end of depol
	endif
	qstx = stx //+ 0.00075														//will be modified later to match peak
	qendx = endx //+ 0.0015													//calculation of Q stops 1.5ms after end of depol

	if (ZeroSubtract)		// TEMP: Should we????
		ZeroCurrent=mean(postwave,0,stx-hl_left)	// TEMP: Zero: from start till stx-hl_left
	else
		//ZeroCurrent=0
		ZeroCurrent=mean(postwave,0,stx-hl_left)	// TEMP: Zero: from start till stx-hl_left
	endif

// No leak correction for now (would this make sense at a later stage?)
//	if  (doleakcorr == 1)
//		NVAR h_ileak=root:MD2temp:h_ileak, d_ileak=root:MD2temp:d_ileak, ICa_i_l=root:MD2temp:ICa_i_l, ICa_f_l=root:MD2temp:ICa_f_l
//		NVAR q_virt_l=root:MD2temp:q_virt_l, q_real_l=root:MD2temp:q_real_l, h_ileak=root:MD2temp:h_ileak
//		NVAR leaktype=root:MD2dialog:leaktype		
//		variable qstx_l, qendx_l
//		make /O W_coef
//
//		q_virt_l =  -(ICa_i_l+ICa_f_l)/2 * depdur									//Q=I*t; with I = average between leak-corrected ICa at beginning and ICa at end of depol
//				
//		qendx_l = qendx
//		qstx_l = 	qstx
//
//		switch(leaktype)	
//			case 1:				// "linear leak"
//			
//				duplicate /O iwave iwave_l
//
//				if (waveexists($"root:MD2temp:"+nameofwave(iwave)+"_leak"))						// If the wave is already p/n corrected, undo the p/n.
//					wave leakwave=$"root:MD2temp:"+nameofwave(iwave)+"_leak"
//					iwave_l+=leakwave
//				endif
//
//				duplicate /O iwave_l pAiwave_l, qwave_l, subwave, wavetofit, slowdeact
//				pAiwave_l = iwave_l * 1e12 - d_ileak
//				qwave_l = iwave_l * 1e12 - d_ileak
//				break
//			case 2:				// "separate p/N pulse"
//				SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
//				SVAR PNfoldername = root:MD2temp:PNfoldername
//				wave leakwave = $CurrAnaFolder+":PoN:"+nameofwave(iwave)+"_leak"
//				
////				duplicate /O iwave pAiwave_l, qwave_l, subwave, wavetofit, slowdeact
////				pAiwave_l = (iwave * 1e12) - (leakwave * 1e12)
////				qwave_l = (iwave * 1e12) - (leakwave * 1e12)
//				wave iwave_l=root:MD2temp:ICa:iwave_l
//				duplicate /O iwave_l pAiwave_l, qwave_l, subwave, wavetofit, slowdeact
//				pAiwave_l *= 1e12
//				qwave_l *= 1e12
//				break
//		endswitch
//	
//		wavetofit *= 1e12
//		FindPeak /B=3 /Q /M=(ICa_f) /N /R=(endx, endx+0.002) wavetofit			// Find max (tail-)current
//		if (V_flag == 0)
//			peak = V_peakloc
//		else 
//			WaveStats /Q /R = (endx, endx+0.002) wavetofit
//			peak = V_minloc
//		endif
//		
//		deletepoints (x2pnt(pAiwave_l, endx+d_right)+1), numpnts(wavetofit), wavetofit
//		deletepoints 0, x2pnt(wavetofit, peak), wavetofit							// trim wavetofit wave to peak of tail current to 25ms+const segment after end of depol
//		SetScale/P x 0,samplefreq,"s", wavetofit, slowdeact
//		V_FitOptions = 4														// suppress curve fit window
//		CurveFit /q dblexp wavetofit
//		if ((W_coef[1] >= 0 ) || (W_coef[4] <= 1000))
//			CurveFit /q exp wavetofit
//		else
//		endif
//		V_FitOptions = 0
//		slowdeact = W_coef[0]+W_coef[1]*exp(-W_coef[2]*x)						// Make slowdeact wave from function fitted to wavetofit. Anything before peak is set to zero.
//		InsertPoints 0, x2pnt(pAiwave_l, peak), slowdeact
//		deletepoints (x2pnt(pAiwave_l, endx+d_right)+1), numpnts(pAiwave_l), slowdeact		
//		slowdeact [0, x2pnt(pAiwave_l, peak)] =0
//
//		subwave= -exp (1/0.00025 * - (x-endx)) + 1								//exp decay of subtracted leakcurrent (0-->1, with tau = 250sec)
//		subwave[0,x2pnt(subwave,endx)]=0
//		slowdeact *= subwave
//
//		switch(leaktype)														// add the leak, since we are subtracting it again below... (I think)
//			case 1:				// "linear leak"
//				qwave_l += subwave*d_ileak
//				break
//			case 2:				// "separate p/N pulse"
//				qwave_l += subwave*leakwave
//				break
//			case 3:				// "Pulse p/N function"
//				qwave_l += subwave*leakwave
//				break
//		endswitch
//
//		qwave_l -= slowdeact													// subtract slow inactivation
//		duplicate /O qwave_l qcalwave_l
//		integrate qwave_l
//
//		If ( endx <= stx+0.002) 													// changed by Aaron to accommodate pulse < 2ms
//			wavestats /Q/R=(stx+Qskp_t,endx) pAiwave_l
//			wavestats /Q/R=(V_maxloc, endx) pAiwave_l
//		Else
//			wavestats /Q/R=(stx+Qskp_t,stx+0.002) pAiwave_l					// changed by Jakob to avoid trouble with small, noisy currents
//			wavestats /Q/R=(V_maxloc, stx+0.002) pAiwave_l
//		Endif
//		
//		if (V_min < 0)
//			if (V_max >= 0)
//				for (qstx_l=stx+0.0005; pAiwave_l(qstx_l)>0; qstx_l+=samplefreq)	//changed to find proper beginning of integral TM
//				endfor
//			else
//				qstx_l = V_maxloc
//			endif
////			for (qendx_l=endx; (qcalwave_l(qendx_l)<= 0 && qendx_l < endx+0.0015); qendx_l+=samplefreq)	// only integrate while current is still <0 and max 1.5 ms after end of depol
//			for (qendx_l=endx; (!(qcalwave_l(qendx_l)>0 && qcalwave_l(qendx_l+samplefreq)>0) && qendx_l < endx+0.0015); qendx_l+=samplefreq)	// only integrate while current is still <0 and max 1.5 ms after end of depol
//			endfor
//			qendx_l -= samplefreq
//			q_real_l = - (qwave_l(qendx_l) - qwave_l(qstx_l))						//Q_l = integral of leak corrected current; given positive and in pC
//		else
//			q_real_l = NaN
//		endif	
//		
//		duplicate /O iwave pAiwave, qwave
//		pAiwave = (iwave-ZeroCurrent) * 1e12
//		qwave = pAiwave - slowdeact
//		duplicate /O qwave qcalwave
//		integrate qwave															//integration of current-wave
//	else
		duplicate /O postwave pAiwave, qwave
		pAiwave = (postwave-ZeroCurrent) * 1e12
		qwave = pAiwave
		duplicate /O qwave qcalwave
		integrate qwave															//integration of current-wave
//	endif
	
	If (endx <= stx+0.002)
		wavestats /Q/R=(stx+Qskp_t,endx) pAiwave
		wavestats /Q/R=(V_maxloc, endx) pAiwave
	Else
		wavestats /Q/R=(stx+Qskp_t,stx+0.002) pAiwave					// changed by Jakob to avoid trouble with small, noisy currents
		wavestats /Q/R=(V_maxloc, stx+0.002) pAiwave
	Endif
	
	q_post = - (qwave(qendx) - qwave(qstx))								//Q = integral of current; given positive and in pC
	
	duplicate /O pAiwave expIwav
			
//	if  (doleakcorr == 1)
//		duplicate /O pAiwave_l expIwav_l
//		deletepoints (x2pnt(pAiwave_l, endx+d_right)+1), numpnts(expIwav_l), expIwav_l
//		if ((stx-d_left)>0)
//			deletepoints 0, x2pnt(pAiwave_l, stx-d_left), expIwav_l
//		elseif ((stx-d_left)<0)
//			insertpoints 0, abs(x2pnt(pAiwave_l, stx-d_left)), expIwav_l
//			expIwav_l[0,abs(x2pnt(pAiwave_l, stx-d_left))]=NaN
//		endif
//		setscale /p x, stx-d_left, samplefreq, expIwav_l
//		slowdeact [0, x2pnt(pAiwave_l, peak)] =NAN
//		deletepoints (x2pnt(pAiwave, qendx_l)+1), numpnts(qcalwave_l), qcalwave_l
//		deletepoints 0, x2pnt(pAiwave, qstx_l), qcalwave_l
//		SetScale/P x qstx_l,samplefreq,"s", qcalwave_l
//		make /o /n=1 rQy_l_stx, rQy_l_endx, rQx_l_stx, rQx_l_endx			// For display of start and end points of leak-corrected Qreal
//		rQy_l_stx[0] = qcalwave_l(qstx_l); rQx_l_stx[0] = qstx_l
//		rQy_l_endx[0] = qcalwave_l(qendx_l); rQx_l_endx[0] = qendx_l
//		make /o /n=4 vQ_l, vQy_l											// For display of leak-corrected Qvirt
//		vQ_l[0] = ICa_i; vQ_l[1] = ICa_i-d_ileak; vQ_l[2] = ICa_f-d_ileak; vQ_l[3] = ICa_f
//		vQy_l[0] = stx; vQy_l[1] = stx; vQy_l[2] = endx; vQy_l[3] = endx
//	endif
		
	deletepoints (x2pnt(pAiwave, endx+d_right)+1), numpnts(expIwav), expIwav
	if ((stx-d_left)>0)
		deletepoints 0, x2pnt(pAiwave, stx-d_left), expIwav
	elseif ((stx-d_left)<0)
		insertpoints 0, abs(x2pnt(pAiwave, stx-d_left)), expIwav
		expIwav[0,abs(x2pnt(pAiwave, stx-d_left))]=NaN
	endif
	setscale /p x, stx-d_left, samplefreq, expIwav
	deletepoints (x2pnt(pAiwave, qendx)+1), numpnts(qcalwave), qcalwave
	deletepoints 0, x2pnt(pAiwave, qstx), qcalwave
	SetScale/P x qstx,samplefreq,"s", qcalwave


	ControlInfo /W=MD2UserDialog cMainDisp
	if (V_Value)
		ControlInfo /W=MD2UserDialog cdisp_Q
		if (V_value)
			SVAR iwavname=root:MD2temp:iwavname
			NVAR wtim_Q=root:MD2dialog:wtim_Q, hl_left=root:MD2temp:hl_left, hl_right=root:MD2temp:hl_right
			
			make /o /n=1 rQy_stx, rQy_endx, rQx_stx, rQx_endx						// For display of start and end points of non-leak-corrected Qreal
			
			rQy_stx[0] = qcalwave(qstx); rQx_stx[0] = qstx
			rQy_endx[0] = qcalwave(qendx); rQx_endx[0] = qendx
			
			display /W=(20,40,screen-20,240) pAiwave as iwavname+"   (full scale)"			// Display entire iwave in gray
			dowindow /C Qwin_f 
			modifygraph /W=Qwin_f rgb = (46000,46000,46000)
			appendtograph /Q /W=Qwin_f /c=(65000,4500,4500) expIwav				// display current depol in red
			label /W=Qwin_f bottom "\\u#2time (sec)"
			label /W=Qwin_f left "\\u#2current (pA)"
			
			display /W=(20,270,screen-20,470) expIwav as iwavname + "   (depol no " + num2str(depcount) + ")"		// Display magnified iwave in gray
			dowindow /C Qwin_d
			modifygraph /W=Qwin_d rgb (expIwav) = (30000,30000,30000)
			appendtograph /Q /W=Qwin_d /c=(65000,4500,4500) qcalwave				// Display magnified current depol in red
			
			appendtograph /Q /W=Qwin_d /c=(0,0,0) rQy_stx vs rQx_stx				// Display start point for Qreal as black circle (later)
			appendtograph /Q /W=Qwin_d /c=(0,0,0) rQy_endx vs rQx_endx			// Display end point for Qreal as black circle (later)
			
			ModifyGraph mode(rQy_stx)=3,marker(rQy_stx)=8
			ModifyGraph mode(rQy_endx)=3,marker(rQy_endx)=8
			
			label /W=Qwin_d bottom "\\u#2time (sec)"
			label /W=Qwin_d left "\\u#2current (pA)"
			setAxis /W=Qwin_d bottom (stx-d_left),( endx+d_right)
			ModifyGraph mode(qcalwave)=7,useNegRGB(qcalwave)=1,usePlusRGB(qcalwave)=1, hbFill(qcalwave)=2,plusRGB(qcalwave)=(65280,43520,32768), negRGB(qcalwave)=(65280,43520,32768)
							// Fill non-leak-corrected Qreal area in light orange
			reordertraces /w=Qwin_d expIwav, {expIwav, qcalwave}
			
			ModifyGraph zero(left)=2
			doupdate

			sleep /s wtim_Q
			dowindow /k Qwin_f
			dowindow /k Qwin_d
		
		endif	
	endif

	SVAR iwavname=root:MD2temp:iwavname	
	duplicate /O expIwav  $currAnafolder+":Currents:"+iwavname+"_post"								// keep the iwave
	duplicate /O qcalwave $currAnafolder+":Currents:"+iwavname+"_Qpost"							// keep the iwave used for qreal

//	killdatafolder root:MD2temp:QCa
end

// ************************************************************************************************************************************
// ** sort the data by time of recording

function md2_sort_waves()

	SVAR SortedWavesStr=root:MD2temp:SortedWavesStr, WavesNotSortedStr=root:MD2temp:WavesNotSortedStr
	SVAR sufx=root:MD2temp:sufx, currAnaFolder=root:MD2temp:currAnaFolder
	WAVE rtim = $(CurrAnaFolder+":rtim"+sufx)
	variable numofwaves, idx=0
	string listofwaves, actualwavestr
	
	setdatafolder $currAnaFolder
	listofwaves = wavelist ("*" , ";" ,"")										//returns a string with all waves in the active data folder
	numofwaves = itemsinlist (listofwaves, ";")

	setdatafolder root:MD2temp
	duplicate /O rtim torg													//is used to keep the original time order of all data
	do 	
		actualwavestr = stringfromlist(idx, listofwaves, ";")
		WAVE actualwave = $(CurrAnaFolder+":"+actualwavestr)
		if ((idx<numofwaves) && (numpnts(torg) == (numpnts(actualwave))) && (strsearch(actualwavestr, sufx, 0) != -1))	//sorts only those waves that have the same number of points as torg and do have a name containing sufx
			sort torg actualwave
			SortedWavesStr += actualwavestr + ", "
		else 
			WavesNotSortedStr += actualwavestr + ", "
		endif
		idx += 1
	while (idx<numofwaves)
	killwaves /Z torg
end

// ************************************************************************************************************************************
// ** creates waves: 	type =1 : only one wave (no index)
// **					type =2 : text wave without index
// **		 			type =3 : several waves indexed from 1 to numdep

Function md2_make_waves(type, namhead)	

	variable type
	string namhead
	NVAR n_files=root:MD2temp:n_files, maxdepnum=root:MD2temp:maxdepnum
	SVAR sufx=root:MD2temp:sufx
	WAVE cm_NaNwav=root:MD2temp:cm_NaNwav
	variable counter
	string wavnam
	
	
	if (type == 1)
		wavnam = namhead + sufx
		if (waveexists($wavnam)==0)
			make /N=(n_files) /O $wavnam
			Note $wavnam, "Created by MultiDepol macro version: "+MDVersion
		endif
	elseif ((type == 2) && (maxdepnum == 0))
		wavnam = namhead + sufx
		make /N=(n_files) /T /O $wavnam
		Note $wavnam, "Created by MultiDepol macro version: "+MDVersion
	elseif (type == 3)
		for (counter=maxdepnum; counter < cm_NaNwav[0]; counter += 1)
			wavnam = namhead + num2str(counter+1) + sufx
			make /N=(n_files) /O $wavnam
			Note $wavnam, "Created by MultiDepol macro version: "+MDVersion
		endfor
	endif
	
End

// ************************************************************************************************************************************	
// ** Set up variables for analysis prior to use	

Function md2_Set_Analysis_Variables(choice)

	string choice
	NVAR doleakcorr=root:MD2dialog:doleakcorr
	SetDataFolder root:MD2temp
	
	strswitch (choice)
	case "all":			// Set variables at beginning of analysis
		variable /g tskp, maxavgtb, maxavgta, tcnstb, tcnsta	// skpt, avgtb, avgta, cnstb, cnsta converted to s (see above)
		variable /g /C dCm								// Stores dCml (real part) and dCms (imag part) of current wave
		variable /g indx=0, idx=0, c=1, depcnt, deptim, stc, enc, depdur, deppot, maxdepnum=0, numofwaves, cnt=0, firsttime, lasttime, actualtime, samplefreq
			// indx: number of current sweep, idx: not globally used?, c: number of depols in current trace?, c, depcnt: counter for number of depols,  
			// deptim, stc, enc: not used, depdur: duration of depol, deppot: depol potential,  maxdepnum: maximum amount of depols in any single sweep?,
			// numofwaves: not globally used?, cnt: counter, firsttime, lasttime, actualtime: time of first, last and current sweep; does not seem to be used anywhere,
			// samplefreq: sample interval of the current-trace
		string /g none="none", twadjststr="timewindow for iICa/fICa was adjusted analyzing these short sweeps/depols: "
			// none, twadjuststr: for reporting timewindow adjustment in infowave
		string /g firstdate, lastdate, actualdate, twiICa="adjusted", twfICa="adjusted", cmdstr, PulseV
			// firstdate, lastdate, actualdate: Date and time of first, last and current sweep, twiICa, twfICa: Information about the time window used for
			// claculating initial and final ICa, cmdstr: command string used for loading XChart data, PulseV: String is "MAC" when reading Pulse data
			// recorded on a Macintosh, "PC" when using a windows PC.
		variable /g pdCm_smoothfactor=20											//constant used for smoothing of Cm-wave,  peak-calculation
		string /g SortedWavesStr, WavesNotSortedStr		// List of waves that have been sorted / have not been sorted
		string /g CurrAnaFolder, sufx						// CurrAnaFolder: where analysis is stored (root:suffix), sufx: "_"+suffix from panel
		string /g PNfoldername							// Name of p/n folder for current sweep?
		variable /g xcsweepno								// Sweep number from Pulse
		variable /g V_rev, V_lj								// V_rev, V_lj: reversal and liquid junction potential in V
		variable /g n_files									// n_files: number of exported Cm traces
		string /g DatFile							// Pulse XChart (.tree) and .dat files (from user panel)
		variable /g XCgroup								// Pulse Experiment number (used for loading the correct XChart data)
		variable /g toffset									// time offset of first sweep; either from XChart file or specified manually
		variable /g match=0, charpos=0, charnum=0, replace=0	// match, charpos, charnum, replace: used for matching current and Cm wave names
		string /g cmwavname, iwavname  // Names of current Cm, I and .txt files and waves
		variable /g iICa_smoothfactor=5						// number of operations to use for binomial smoothing of the current wave
		variable /g ICa_i, ICa_f, Ipeak, t_peak, twadjust=0		// ICa_i, ICa_f, Ipeak: inital final and peak ICa in pA (from smoothed wave), t_peak: time of Ipeak in s
															// twadjust: is 1 if timewindow for ICa_i and ICa_f had to be adjusted (short depols)
		variable /g q_real, q_virt, ileak_t, Qskp_t=0.0003		// q_real: ICa integral, q_virt: (ICa_i+ICa_f) / 2 * depol time, ileak_t: not used, Qskp_t: time to skip after onset
															// of depol for calculation of Q_real
		variable /g q_post									// postsynaptic charge transfer (integral of second current)
		string /G IEnding=""								// Ending of Patchmaster current trace files
		string /G CmEnding=""							// Ending of Patchmaster capacitance trace files
	
		if (doleakcorr==1)
			variable /g h_ileak, d_ileak, ICa_i_l, ICa_f_l, Ipeak_l	// h_ileak: average leak current during constant segment of current sweep, d_ileak: leak current calculated
															// for depol potential (linear leak correction), ICa_i_l, ICa_f_l, Ipeak_l: leak corrected currents
			variable /g q_virt_l, q_real_l							// leak corrected q_real and q_virt
		endif
 
		make /C /O cm_NaNwav, cm_plus_NaNwav, I_NaNWav				//this wave stores all start- and end-points of the sweep's sine waves
		make /O nanpot

	case "Ca_tw":										// Reset the variables for the time window for ICa measurement
		variable /g iI_left=0.003, iI_right=0.010										//sets timewindow for measurement of initial ICa relative (+) to beginning of depol [sec]
		variable /g fI_left=0.0025, fI_right=0.0005										//sets timewindow for measurement of final ICa relative (-) to end of depol [sec]
		variable /g hl_left=0.001, hl_right=0.0										//sets timewindow for measurement of leak current during constant at holding potential relativ (-) to beginning of depol [sec] (stx-hl_left,stx-hl_right)
	
		break
	endswitch
End	

// ************************************************************************************************************************************
// ** Returns the width of the screen in points (Only works correctly if the standard Windows setting of 96 dpi is selected
// **     in Display Properties --> Settings --> Advanced --> General)

function md2_getscreeninfo()

	string info
	variable right, bottom, pos
	
	info = stringbykey("screen1",igorinfo(0),":")
	pos = strsearch(info, "RECT=",0)
	right = str2num(info[pos+9, strsearch(info, ",",pos+9)])
	bottom = str2num(info[strsearch(info, ",",pos+9)+1, strlen(info)])
	return right/96*72
end

// ************************************************************************************************************************************
// ** Button for changing the selection of traces to analyze

Function md2_ReselectButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			md2_SelectorWin()
			break
	endswitch

	return 0
End

// *****************************************************************************************
// ** Rename all PPT-imported Pulse/Patchmaster data in folder according to the
// **  stimulation protocol used for recording. BeLiberal=1 parameter allows liberal names.

function md2_pm2pulse([beliberal, delete])

variable beliberal	// set to 1 to use liberal naming conventions
variable delete	// set to 1 to delete all "extra" traces (which are not current, leak, stim, gm, gs, or cm)

string alllist=wavelist("*",";","")		// all waves in folder
string currlist						// all traces of one series
string prefix						// Name of trace up to series number
string numbers					// numbers of experiment, series, and sweep
string postfix						// numbers of experiment, series, and sweep plus trace id name ("Imon-1", "_CM", etc.)
string newname					// new wave name for renaming
string pgfname					// name of stimuls protocol

variable i

if (paramisdefault(beliberal))
	beliberal=0
endif
if (paramisdefault(delete))
	delete=0
endif

alllist=GrepList(alllist,"^.+_[[:digit:]]+_[[:digit:]]+_[[:digit:]]+.*")		// List of all waves with three digits separated by lowerspaces
Do
	prefix=stringfromlist(0,alllist)[0,strsearch(stringfromlist(0,alllist),"_",strsearch(stringfromlist(0,alllist),"_",strsearch(stringfromlist(0,alllist),"_",0)+1)+1)]+"*"	// Wavename up to series number
	currlist=ListMatch(alllist,prefix)		// all sweeps and traces of current series
	for (i=0;i<itemsinlist(currlist);i+=1)	// find name of stimulation used, is not in all traces
		wave currwav=$stringfromlist(i,currlist)
		if (strlen(stringbykey("Stimulation",replacestring("\r",replacestring("\t",note(currwav),""),""),":",";"))>0)
			pgfname=stringbykey("Stimulation",replacestring("\r",replacestring("\t",note(currwav),""),""),":",";")
		endif
	endfor
	if (strlen(pgfname)>0)
		for (i=0;i<itemsinlist(currlist);i+=1)
//			prefix=stringfromlist(0,currlist)[0,strsearch(stringfromlist(0,currlist),"_",0)-1]
			postfix=stringfromlist(i,currlist)[strsearch(stringfromlist(i,currlist),"_",0),inf]
			SplitString /E="(_[[:digit:]]+_[[:digit:]]+_[[:digit:]]+)" postfix, numbers	// obtain the part containing the numbers for experiment, series, and sweep
											// Rename the following traces according to Pulse conventions:
			if ((stringmatch(postfix,"*mon*"))&&(!stringmatch(postfix, "*Vmon*"))&&(!stringmatch(postfix, "*V-mon*")))		// Current trace (Imon-1, Imon1, I-mon-1, etc...), but not Vmon
				postfix=numbers
			elseif (stringmatch(postfix,"*leak*"))	// p/n leak trace
				postfix=numbers+"_leak"
			elseif (stringmatch(postfix,"*stim*"))	// stimulus trace
				postfix=numbers+"_stim"
			elseif (stringmatch(postfix,"*_cm"))	// capacitance
				postfix=numbers+"_cm"
			elseif (stringmatch(postfix,"*_gm"))	// membrane conductance
				postfix=numbers+"_gm"
			elseif (stringmatch(postfix,"*_gs"))	// series conductance
				postfix=numbers+"_gs"
			else 
				if (delete)	// set postfix to "" to tag wave for deletion
					postfix=""
				endif
			endif
			if ((strlen(postfix)>0))	// rename current, p/n, stim, Cm, Gs, or Gm trace, rename other traces if desired
				newname=cleanupname(pgfname+postfix,beliberal)
				wave currwav=$stringfromlist(i,currlist)
				rename currwav, $newname
			else								// other traces: delete if desired
				wave currwav=$stringfromlist(i,currlist)
				killwaves currwav
			endif
		endfor
	endif
	alllist=removefromlist(currlist,alllist)
while (itemsinlist(alllist)>0)

end


// ************************************************************************************************************************************
// ** Rename the imported Patchmaster waves to fit the naming scheme of Pulse:
// ** Change by Aaron to accommondate variable nomenclature due to different PPT versions and setup-dependent difference in Stim-DA channel
// ** Wavenames in the regular pattern "PMPulse_x_x_x_ysssss" where sssss is the suffix (e.g. "_Imon-1" or "-Imon")
// ** If suffix contains "Imon" (case-insensitive) renames to 	PMPulse_x_x_x
// ** 	and converts the corresponding stimulus wave into 	PMPulse_x_x_x_stim
// **		*Possible bug: may not find the correct stimulus if multiple Imon channels are involved.
// ** If suffix contains "leak" (case-insensitive) renames to 		PMPulse_x_x_x_leak
// ** If suffix contains "CM" (case-insensitive) renames to 		PMPulse_x_x_x_Cm, the (actually correct) dimoffset of (dimdelta/2) is set to 0 to be the same as imported Pulse traces
// ** If suffix contains "GM" (case-insensitive) renames to 		PMPulse_x_x_x_Gm, the (actually correct) dimoffset of (dimdelta/2) is set to 0 to be the same as imported Pulse traces
// ** If suffix contains "GS" (case-insensitive) renames to 		PMPulse_x_x_x_Gs, the (actually correct) dimoffset of (dimdelta/2) is set to 0 to be the same as imported Pulse traces
// ** Any other traces are deleted!


Function md2_RenamePM()

 string Liststr, ImonListStr
 variable i,j
 string wavnam, stimwavnam

 ListStr=WaveList("*",";","")
 ImonListStr=GrepList(ListStr, "(?i)Imon")
 ListStr = RemoveFromList(ImonListStr, ListStr)
 Variable expt, series, sweep, trace
 String suffix

 // Renaming all Imon waves, and their respective stimulus waves
 for (j=0;j<ItemsInList(ImonListStr);j+=1)
	wavnam=StringFromList(j,ImonListStr)
	wave currwave=$wavnam
	sscanf wavnam[strsearch(wavnam,"_",0),inf], "_%d_%d_%d_%d%s", expt, series, sweep, trace, suffix
	stimwavnam = md2_getstringfromnote(currwave,"StimWave:")
	wave stimwave = $stimwavnam
	wavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)
	if (Stringmatch(suffix,"*2"))		// Identify Imon-2, Imon2 etc.
		wavnam=wavnam+"_2"
	endif
	rename currwave $wavnam
	
	// Removing StimWv from ListStr and renaming StimWv
	ListStr = RemoveFromList(stimwavnam, ListStr)
	stimwavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)+"_stim"
	if (waveexists(stimwave))
		rename stimwave $stimwavnam
	endif
 endfor

 // Renaming Cm, Gs, Gm waves and killing all other waves
 i=ItemsInList(ListStr)
 for (j=0;j<i;j+=1)
	 wavnam=StringFromList(j,ListStr)
	 wave currwave=$wavnam
	 sscanf wavnam[strsearch(wavnam,"_",0),inf], "_%d_%d_%d_%d%s", expt, series, sweep, trace, suffix
	 if (GrepString(suffix,"(?i)Imon")) // Should not happen with ImonListStr removed
		 stimwavnam = md2_getstringfromnote(currwave,"StimWave:")
		 wave stimwave = $stimwavnam
		 wavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)
		 rename currwave $wavnam
		 stimwavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)+"_stim"
		 rename stimwave $stimwavnam
	 elseif (GrepString(suffix,"(?i)leak"))
		 wavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)+"_leak"
		 rename currwave $wavnam
	 elseif (GrepString(suffix,"(?i)Cm")||GrepString(suffix,"(?i)Cm_[0-9]"))
		 setscale /P x,0,dimdelta(currwave,0),currwave
		 wavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)+"_Cm"
		 rename currwave $wavnam
	 elseif (GrepString(suffix,"(?i)GM")||GrepString(suffix,"(?i)GM_[0-9]"))
		 setscale /P x,0,dimdelta(currwave,0),currwave
		 wavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)+"_Gm"
		 rename currwave $wavnam
	 elseif (GrepString(suffix,"(?i)GS")||GrepString(suffix,"(?i)GS_[0-9]"))
		 setscale /P x,0,dimdelta(currwave,0),currwave
		 wavnam="PMPulse_"+num2str(expt)+"_"+num2str(series)+"_"+num2str(sweep)+"_Gs"
		 rename currwave $wavnam
	 else
		 killwaves currwave
	 endif
 endfor

 end


// ************************************************************************************************************************************

Function md2_CurrentsOnlyCheckProc(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			Variable checked = cba.checked
			md2_MakeList()
			break
	endswitch

	return 0
End


// ************************************************************************************************************************************
// ** Get start and end of depolarization from stimulus wave (For Currentsonly mode)

Function md2_get_depol_times(InWave)

wave InWave
wave stimwave=$"root:MD2temp:"+nameofwave(InWave)+"_stim"
variable holding=md2_getfromnote(InWave,"Holding")/1000

	NVAR PatchMaster=root:MD2dialog:PatchMaster
	NVAR xcsweepno=root:MD2temp:xcsweepno
	NVAR tcnstb=root:MD2temp:tcnstb
	NVAR tcnsta=root:MD2temp:tcnsta	
	SVAR PulseV=root:MD2temp:PulseV
	SVAR PNfoldername=root:MD2temp:PNfoldername
	SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
	SVAR cmwavname=root:MD2temp:cmwavname
	SVAR iwavname=root:MD2temp:iwavname
	WAVE /C cm_NaNwav=root:MD2temp:cm_NaNwav								//this wave stores all start- and end-points of the sweep's sine waves					
	WAVE /C cm_plus_NaNwav=root:MD2temp:cm_plus_NaNwav									//this wave stores all start- and end-points of the sweep's sine waves
	WAVE /C I_NaNwav=root:MD2temp:I_NaNwav									//this wave stores all start- and end-points of the sweep's sine waves
	WAVE nanpot=root:MD2temp:nanpot
	string olddatafolder, stimwavename

	nanpot = nan
	stimwavename=nameofwave(stimwave)
	
	variable startp, endp=-1, npts, index, sinecount, depcount, endofwav=0, baddep=0, i, endpi, startpi

	npts = numpnts(stimwave)
	
	cm_NaNwav=NaN
	cm_plus_NaNwav=NaN
	I_NaNwav=NaN
	I_NaNwav[0] = 0																//will be set to 1 if 0ms depol is detected
	
		for (sinecount=1 ; endofwav!=1 ; sinecount+=1)								//loop and count number of depols until end of sweep
			for (index=(endp+1) ; !(abs(stimwave[index]-Holding)<0.001) ; index+=1)			//loop until end of NaN segment (newer versions of Pulse export NaN for 1st points)
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(inwave), "does not contain any sine wave"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this means that the wave stops within the depol!!! no calculation possible
					endofwav=1
					baddep=1
					break
				endif
			endfor

			startp = index														//startp = 1st non-NaN-point of current depol
	
			for (index=startp ; (abs(stimwave[index]-Holding)<0.001 && endofwav!=1) ; index+=1)	//loop until beginning of next NaN segment
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(inwave), "does not contain any depolarization"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this is the normal end of the wave
					endofwav=1
					index+=1
					break
				endif
			endfor
			endp = (index-1)														//last point before next NaN segment begins or endpoint
		
			depcount = (sinecount-1-baddep)
			cm_NaNwav[(sinecount)] = cmplx(pnt2x(InWave, startp), pnt2x(InWave, endp))		//start and end-x of each sine-segment  !! x !!
			cm_plus_NaNwav[(sinecount)] = cmplx(pnt2x(InWave, startp-1), pnt2x(InWave, endp+1))	//last x (of depol+cnst) before and first x (of depol+cnst) after sine-segment  !! x !!
//			I_NaNwav[(sinecount)] = cmplx(pnt2x(stimwave, startp)-tcnstb, pnt2x(stimwave, endp)+tcnsta)		// start- and end-x of each sine for the I wave
			I_NaNwav[(sinecount)] = cmplx(pnt2x(stimwave, startp), pnt2x(stimwave, endp))		// start- and end-x of each sine for the I wave
			nanpot[sinecount] = 1e3 * stimwave(pnt2x(stimwave, endp) + tcnstb)				// depol potential after sinewave

		endfor

	cm_NaNwav[0] = (depcount)
	cm_plus_NaNwav[0] = (depcount)
end


end


// ************************************************************************************************************************************
// ** Display a warning when using the experimental slope correction

Function md2_SlopeCorrWarning(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			Variable checked = cba.checked
			if (checked)
				DoAlert 1, "WARNING! This is a purely experimental feature which most likely mess up your data!\rDon't use this if you don't know EXACTLY what you're doing!\rAre you sure you wish to continue?"
				if (V_flag==2)
					NVAR DoSlopeCor=root:MD2dialog:DoSlopeCor
					DoSlopeCor=0
				endif
			endif
			break
	endswitch

	return 0
End

// ************************************************************************************************************************************
// ** Display a warning when using the two channel feature

Function md2_TwoChanWarning(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			Variable checked = cba.checked
			if (checked)
				DoAlert 1, "WARNING! This feature is still under construction and will most likely not return anything you could really use!\rDon't use this if you're not planning to work on improving the code.\rAre you sure you wish to continue?"
				if (V_flag==2)
					NVAR TwoChan=root:MD2dialog:TwoChan
					TwoChan=0
				endif
			endif
			break
	endswitch

	return 0
End


// ************************************************************************************************************************************
// ** Build a custom p/n wave from the preceeding series (for "separate p/n series" leak correction)

function /S md2_BuildLeakWave(iwave)

wave iwave

string leakname = nameofwave(iwave)
string seriesstring, preseries, postseries
variable seriesnum
SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
NVAR SepPoNPulse=root:MD2dialog:SepPoNPulse

splitstring /E="(.+_[0-9]+_)([0-9]+)(_[0-9]+)" leakname, preseries, seriesstring, postseries
seriesnum = str2num(seriesstring)
string oldfolder=getdatafolder(1)
setdatafolder root:MD2allseries:
leakname=wavelist("*_"+num2str(seriesnum+SepPoNPulse)+postseries,";","")
setdatafolder $oldfolder
if (itemsinlist(leakname)==1)
leakname=removeending(leakname,";")
wave leakwave = $"root:MD2allseries:"+leakname
splitstring /E="(.+_[0-9]+_)([0-9]+)(_[0-9]+)" leakname, preseries, seriesstring, postseries
if (waveexists (leakwave))
	duplicate /O leakwave $CurrAnaFolder+":PoN:Pulse_"+num2str(seriesnum)+postseries+"_leak"
	duplicate /O $"root:MD2allseries:"+preseries+num2str(seriesnum+SepPoNPulse)+postseries+"_stim" $CurrAnaFolder+":PoN:Pulse_"+num2str(seriesnum)+postseries+"_leak_stim"	
	if (waveexists($"root:MD2allseries:"+preseries+num2str(seriesnum+SepPoNPulse)+postseries+"_leak"))
		duplicate /O $"root:MD2allseries:"+preseries+num2str(seriesnum+SepPoNPulse)+postseries+"_leak" $CurrAnaFolder+":PoN:Pulse_"+num2str(seriesnum)+postseries+"_leak_leak"
	endif
	return "Pulse_"+num2str(seriesnum)+postseries+"_leak"
endif
else
	print "No leak wave found for "+leakname+"!"
	beep
endif
end


// ************************************************************************************************************************************
// ** Get start and end of depolarization from stimulus wave of leak trace (for "separate p/n series" leak correction)

Function md2_get_leak_depol_times(InWave)

wave InWave

	NVAR PatchMaster=root:MD2dialog:PatchMaster
	NVAR xcsweepno=root:MD2temp:xcsweepno
	NVAR tcnstb=root:MD2temp:tcnstb
	NVAR tcnsta=root:MD2temp:tcnsta	
	SVAR PulseV=root:MD2temp:PulseV
	SVAR PNfoldername=root:MD2temp:PNfoldername
	SVAR CurrAnaFolder = root:MD2temp:CurrAnaFolder
	SVAR cmwavname=root:MD2temp:cmwavname
	SVAR iwavname=root:MD2temp:iwavname
	WAVE /C cm_NaNwav=root:MD2temp:ICa:Leak_cm_NaNwav								//this wave stores all start- and end-points of the sweep's sine waves					
	WAVE /C leak_cm_plus_NaNwav=root:MD2temp:leak_ICa:Leak_cm_plus_NaNwav									//this wave stores all start- and end-points of the sweep's sine waves
	WAVE /C I_NaNwav=root:MD2temp:ICa:Leak_I_NaNwav									//this wave stores all start- and end-points of the sweep's sine waves
	WAVE nanpot=root:MD2temp:ICa:Leak_nanpot
	string olddatafolder, stimwavename
	wave stimwave=$CurrAnaFolder+":PoN:"+nameofwave(InWave)+"_stim"
	variable holding=md2_getfromnote(InWave,"Holding")/1000
	nanpot = nan
	stimwavename=nameofwave(stimwave)
	
	variable startp, endp=-1, npts, index, sinecount, depcount, endofwav=0, baddep=0, i, endpi, startpi

	npts = numpnts(stimwave)
	
	cm_NaNwav=NaN
	leak_cm_plus_NaNwav=NaN
	I_NaNwav=NaN
	I_NaNwav[0] = 0																//will be set to 1 if 0ms depol is detected
	
		for (sinecount=1 ; endofwav!=1 ; sinecount+=1)								//loop and count number of depols until end of sweep
			for (index=(endp+1) ; !(abs(stimwave[index]-Holding)<0.001) ; index+=1)			//loop until end of NaN segment (newer versions of Pulse export NaN for 1st points)
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(inwave), "does not contain any sine wave"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this means that the wave stops within the depol!!! no calculation possible
					endofwav=1
					baddep=1
					break
				endif
			endfor

			startp = index														//startp = 1st non-NaN-point of current depol
	
			for (index=startp ; (abs(stimwave[index]-Holding)<0.001 && endofwav!=1) ; index+=1)	//loop until beginning of next NaN segment
				if (sinecount==1 && (index+1)==npts)
					print "the wave", nameofwave(inwave), "does not contain any depolarization"
					return NaN
				endif
				if ((index+1)==npts)												//if true, this is the normal end of the wave
					endofwav=1
					index+=1
					break
				endif
			endfor
			endp = (index-1)														//last point before next NaN segment begins or endpoint
		
			depcount = (sinecount-1-baddep)
			cm_NaNwav[(sinecount)] = cmplx(pnt2x(InWave, startp), pnt2x(InWave, endp))		//start and end-x of each sine-segment  !! x !!
			Leak_cm_plus_NaNwav[(sinecount)] = cmplx(pnt2x(InWave, startp-1), pnt2x(InWave, endp+1))	//last x (of depol+cnst) before and first x (of depol+cnst) after sine-segment  !! x !!
//			I_NaNwav[(sinecount)] = cmplx(pnt2x(stimwave, startp)-tcnstb, pnt2x(stimwave, endp)+tcnsta)		// start- and end-x of each sine for the I wave
			I_NaNwav[(sinecount)] = cmplx(pnt2x(stimwave, startp), pnt2x(stimwave, endp))		// start- and end-x of each sine for the I wave
			nanpot[sinecount] = 1e3 * stimwave(pnt2x(stimwave, endp) + tcnstb)				// depol potential after sinewave

		endfor

	cm_NaNwav[0] = (depcount)
	leak_cm_plus_NaNwav[0] = (depcount)
	return md2_getfromnote(inwave,"Holding:")/1000
end

// ************************************************************************************************************************************
// ** Clean Up button: Empties the md2allseries folder

Function md2_CleanUpButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			string olddatafolder=getdatafolder(1)
			olddatafolder=removeending(olddatafolder,"MD2allseries:")
			setdatafolder $olddatafolder
			killdatafolder /Z root:MD2allseries
			newdatafolder root:MD2allseries
			md2_MakeList()
			break
	endswitch

	return 0
End

// *************************************************************************************************************
// ** Adjust X range: Adjust the x-range of the selector window's graphs to the specified values

function md2_adjustxrange()

	NVAR startx=root:MD2dialog:ShowFromStart
	NVAR endx=root:MD2dialog:ShowFromEnd
	ControlInfo md2_showfromsetvar
	startx=V_Value
	ControlInfo md2_showtosetvar
	endx=V_Value
	SetAxis /W=MD2SelectorWin#G0 bottom startx,endx
	SetAxis /W=MD2SelectorWin#G0/A=2 left				// Autoscale in visible range
	SetAxis /W=MD2SelectorWin#G1 bottom startx,endx
	SetAxis /W=MD2SelectorWin#G1/A=2 left				// Autoscale in visible range
end

// *************************************************************************************************************
// ** Update the graphs when changing the X range to be displayed

Function md2_XRangeVar(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			Variable dval = sva.dval
			String sval = sva.sval
			md2_adjustxrange()
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

// *************************************************************************************************************
// ** Disable or enable the Show from... ...to SetVariable controls when toggling the checkbox

Function md2_showfromCheckProc(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			Variable checked = cba.checked
			if (checked)
				SetVariable md2_showfromsetvar disable=0
				SetVariable md2_showtosetvar disable=0
				TitleBox md2_showfromtitle disable=0
				md2_adjustxrange()
			else
				SetVariable md2_showfromsetvar disable=2
				SetVariable md2_showtosetvar disable=2
				TitleBox md2_showfromtitle disable=2
				SetAxis /W=MD2SelectorWin#G0/A=1 bottom
				SetAxis /W=MD2SelectorWin#G0/A=1 left
				SetAxis /W=MD2SelectorWin#G1/A=1 bottom
				SetAxis /W=MD2SelectorWin#G1/A=1 left
			endif
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End


// *****************************************************************************************
// ** Rename all PPT-imported Pulse/Patchmaster data in folder according to the
// **  stimulation protocol used for recording. BeLiberal=1 parameter allows liberal names.

function md2_renppt([beliberal])

variable beliberal
string alllist=wavelist("*",";","")
string currlist, prefix, postfix, newname, pgfname
variable found=0
variable i,expe,seri,swee

if (paramisdefault(beliberal))
	beliberal=0
endif

alllist=GrepList(alllist,"^.+_[[:digit:]]+_[[:digit:]]+_[[:digit:]]+.*")
Do
	prefix=stringfromlist(0,alllist)[0,strsearch(stringfromlist(0,alllist),"_",strsearch(stringfromlist(0,alllist),"_",strsearch(stringfromlist(0,alllist),"_",0)+1)+1)]+"*"
	currlist=ListMatch(alllist,prefix)
	for (i=0;i<itemsinlist(currlist);i+=1)
		wave currwav=$stringfromlist(i,currlist)
		if (strlen(stringbykey("Stimulation",replacestring("\r",replacestring("\t",note(currwav),""),""),":",";"))>0)
			pgfname=stringbykey("Stimulation",replacestring("\r",replacestring("\t",note(currwav),""),""),":",";")
		endif
	endfor
	if (strlen(pgfname)>0)
		for (i=0;i<itemsinlist(currlist);i+=1)
			postfix=stringfromlist(i,currlist)[strsearch(stringfromlist(i,currlist),"_",0),inf]
			newname=cleanupname(pgfname+postfix,beliberal)
			wave currwav=$stringfromlist(i,currlist)
			rename currwav, $newname
		endfor
	endif
	alllist=removefromlist(currlist,alllist)
while (itemsinlist(alllist)>0)

end

// ************************************************************************************************************************************
// ** Get data of current traces (iICa, fICa, pICa, tpeak) as well as leak corrected versions, when appropriate

Function md2_get_RsError(iwave, depcount)

	wave  iwave
	variable depcount
	
	NVAR tcnstb=root:MD2temp:tcnstb, 	tcnsta=root:MD2temp:tcnsta
	WAVE cm_plus_NaNwav=root:MD2temp:cm_plus_NaNwav
	md2_Set_Analysis_Variables("Ca_tw")												// reset timewindow variables

	variable stx, endx, a, b, ZeroCurrent
	
	Wave leakwave = $GetWavesDataFolder(iwave, 1)+NameOfWave(iwave)+"_leak"

	If(WaveExists(leakwave))
		newdatafolder /o/s root:MD2temp:ICa
		Duplicate/O iwave, iwave_raw
		iwave_raw += leakwave
	Else
		Wave iwave_raw =  $GetWavesDataFolder(iwave, 1)+NameOfWave(iwave)
	Endif
	
	Variable Rs = (MD2_getfromnote(iwave,"RSeries") - MD2_getfromnote(iwave,"RSvalue")) * 1e6		// in Ohm 

	stx = imag(cm_plus_NaNwav[depcount]) + tcnstb									//first x after sinewave and after constant = beginning of depol
	endx = real(cm_plus_NaNwav[depcount+1]) - tcnsta									//last x of depol
	
	Wavestats/Q/R=(stx,endx) iwave_raw
	
	Variable RsError = V_avg * Rs

	Return RsError
	
End